// Shader for the custom map "dom_attack", which is based on "Loffy's Madness".
// Game: Enemy Territory. Mod: Domination, Powerball and CTF.
// By Loffy, Sweden (http://www.loffy.tk), August 2005.

textures/dom_tex_used_in_attack/concretem05
{
	nopicmip
	implicitMap -
}

textures/navarone/navarone_fog // From Drakir's Navarone-map.
{
	qer_editorimage textures/sfx/fog_grey1.tga
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	fogparms ( 0.4 0.4 0.4 ) 3000
}

textures/dom_tex_used_in_attack/red_blink
{
	qer_editorimage textures/sfx/construction.tga
	cull none
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
        map textures/sfx/construction.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.5 0.5 0 0.5
		tcgen environment
	}
	{
		map $whiteimage
		blendfunc filter
		rgbGen const ( 1.0 0.6 0.6 )
	}
}

textures/dom_tex_used_in_attack/green_blink
{
	qer_editorimage textures/sfx/construction.tga
	cull none
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
        map textures/sfx/construction.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.5 0.5 0 0.5
		tcgen environment
	}
	{
		map $whiteimage
		blendfunc filter
		rgbGen const ( 0.6 1.0 0.6 )
	}
}

textures/lm_tex/lm_sign_pb // A sign.
{
	surfaceparm woodsteps
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/lm_tex/lm_sign_ctf // A sign.
{
	surfaceparm woodsteps
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/woodc01
{
	surfaceparm woodsteps
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

// --- A mirror shader, thanks to Erik, Stockholm ---

textures/lm_tex/erikspegel
{
	qer_editorimage textures/lm_tex/erikspegel.tga
	surfaceparm nolightmap
    nopicmip
	portal
	{
		map textures/lm_tex/erikspegel.tga
		blendfunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		depthWrite
	}
}

textures/lm_tex/dirtm03
{
    qer_editorimage textures/lm_tex/dirtm03.jpg
    surfaceparm landmine
    surfaceparm gravelsteps
    nopicmip
    {
		map textures/lm_tex/dirtm03.jpg

    }
}

textures/dom_tex_used_in_attack/metalm04dg2
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/wall03mid
{
	nopicmip
	// nocompress
	// nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/wall02midblue
{
	nopicmip // Ignore user-set values for the r_picmip cvar command.
	// nocompress // Ignore texture compression
	// nomipmaps // nopicmip plus prevents lower resolution mipmaps for use by the 3D card.
	implicitMap -
}

textures/dom_tex_used_in_attack/wall02midred
{
	nopicmip
	// nocompress
	// nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/wall02midblue2
{
	nopicmip // Ignore user-set values for the r_picmip cvar command.
	// nocompress // Ignore texture compression
	// nomipmaps // nopicmip plus prevents lower resolution mipmaps for use by the 3D card.
	implicitMap -
}

textures/dom_tex_used_in_attack/wall02midred2
{
	nopicmip
	// nocompress
	// nomipmaps
	implicitMap -
}


textures/dom_tex_used_in_attack/sdchurch // Used as a floor texture.
{
	nopicmip
	implicitMap -
}

textures/dom_tex_used_in_attack/sdtown // Used as a floor texture.
{
	nopicmip
	implicitMap -
}

textures/loffys_ctf_prefab/lcp_1618 // The numbers 1.618 on a sign (the golden cut).
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/loffys_ctf_prefab/lcp_1337 // The numbers 1337 on a sign (ELITE SPE4K).
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/loffys_ctf_prefab/lcp_allies_sign // A sign that says "Allies".
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/loffys_ctf_prefab/lcp_axis_sign // Dito "Axis".
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/fff_mayhem/sign_alli // Flag.
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/fff_mayhem/sign_axis // Flag.
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm woodsteps
	implicitMap -
}

textures/fff_mayhem/en_vanlig_pil // An arrow.
{
	surfaceparm woodsteps
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/lofmadness/lofmadness_sky // The sky shader.
{
	nocompress
	qer_editorimage textures/skies/topclouds.tga
	q3map_sunExt 1 .96 .87 140 140 45 2 16		// Red green blue intensity degrees elevation (0 is a low sun, 90 is noon) deviance and samples
	q3map_lightmapFilterRadius 0 4				// Amount of filtering applied on the lightmap. First value for self (always "0" on sky shaders since skies don't have lightmaps), second value on others.
	q3map_skylight 50 3 								// Amount iterations (e.g.  100 6)
	q3map_nofog

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky

	skyparms textures/skies_sd/wurzburg_env/sky 512 -
	sunshader textures/skies_sd/batterysunfog

	{
		fog off
		map textures/skies_sd/battery_clouds.tga
		tcMod scale 2.5 2.5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/battery_mask_ydnar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen const ( 0.4 0.4 0.4 )
	}
}


// The next sky shader is identical except the degrees-value.
// The degrees indicate the sun's angle relative to the direcions of the map file.
// A setting of 0 degrees equals east. 90 is north, 180 is west and 270 is south.

textures/lofmadness/lofmadness_sky2
{
	nocompress
	qer_editorimage textures/skies/topclouds.tga
	q3map_sunExt 1 .96 .87 140 320 45 2 16		// Red green blue intensity degrees elevation (0 is a low sun, 90 is noon) deviance and samples
	q3map_lightmapFilterRadius 0 4				// Amount of filtering applied on the lightmap. First value for self (always "0" on sky shaders since skies don't have lightmaps), second value on others.
	q3map_skylight 50 3 								// Amount iterations (e.g.  100 6)
	q3map_nofog

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky

	skyparms textures/skies_sd/wurzburg_env/sky 512 -

	sunshader textures/skies_sd/batterysunfog


	{
		fog off
		map textures/skies_sd/battery_clouds.tga
		tcMod scale 2.5 2.5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/battery_mask_ydnar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen const ( 0.4 0.4 0.4 )
	}
}

levelshots/dom_attack_cc_automap
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/dom_attack_cc.jpg
		depthFunc equal
		rgbGen identity
	}
}

levelshots/dom_attack_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/dom_attack_cc.jpg
		blendfunc blend
		rgbGen identity
		alphaGen vertex
	}
}

// --- Drakir's tex (www.drakir.tk) ---


textures/dom_tex_used_in_attack/drbox4
{
	surfaceparm woodsteps
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drbox6
{
	surfaceparm woodsteps
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant02
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant03
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant04
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant05
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant07
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant08
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant09
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant10
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant13fullblue
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant13fullred
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant15
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant16
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant17
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant20
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant21
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant22
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant24
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant28
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant29
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant30
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant31
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}

textures/dom_tex_used_in_attack/drsteelplant32
{
	nopicmip
	nocompress
	nomipmaps
	implicitMap -
}