//
// maker_env.shader
//
// Sky / Liquids / Fogs
//

//=====================================
// SKY
//=====================================

textures/maker_env/st_sky
{
	qer_editorimage textures/skies_sd/wurzburg_clouds.tga
	nocompress
	skyparms - 200 -
	sunshader textures/skies_sd/full_moon2
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky
	q3map_skyLight 80 3 //q3map_skyLight 80 3 //ydnar suggested for tests
	nopicmip
	nomipmaps

	skyparms textures/skies_sd/wurzburg_env/sky 512 -

	{	
		fog off
		map textures/skies_sd/goldrush_clouds.tga
		tcMod scale 5 5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}

	{	
		fog off
		map textures/skies/nightsky1.jpg
		tcMod scale 10 10
		blendfunc add
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/goldrush_mask.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen const ( 0.35 0.35 0.35 ) 
	}
}

// ======================================================================
// Liquids
// ======================================================================

//stone/mxdebris0_riverbed.tga

textures/maker_env/water_pond
{
	nocompress
	qer_editorimage textures/maker/terrain/water.tga
	qer_trans .5
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	cull disable
	deformVertexes wave 512 sin 1 3 0.75 0.2
	nopicmip
	waterfogvars ( 0.6 0.7 0.8 ) 500
	{ 
		fog on
		map textures/maker/terrain/water.tga
		depthWrite
		blendFunc blend
		rgbgen identity
		tcmod scale 0.3 0.3
		tcmod scroll 0.005 0.001
		tcgen environment
	}
	{
		fog on
		map textures/maker/terrain/water.tga
		blendFunc add
		tcmod scale 0.05 0.05
		tcmod scroll -.001 -.0002
		tcgen environment
	}
	{
		map $lightmap
		blendFunc filter
		rgbGen identity
	}

}

// ======================================================================
// Fogs
// ======================================================================

textures/maker_env/fog
{
	qer_editorimage textures/maker/editor/fog.tga
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	surfaceparm noimpact
	surfaceparm nomarks
//	cull disable
	fogparms ( 0.3 0.5 0.3 ) 6000
}

textures/maker_env/fog_cave
{
	qer_editorimage textures/maker/editor/fog.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm	nolightmap
	q3map_globaltexture
	q3map_surfacelight 1
//	fogparms ( .15 .15 .17 ) 768
	fogparms ( .2 .2 .2 ) 384
//	fogparms ( .5 .5 .5 ) 128
	{
		map textures/marko/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}
	{
		map textures/marko/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}

