//Shaders by Sage
//*********************
//Last edit 06.02.2009 13:10

//Textures used for the terrain shaders:
//
//1:	textures/desert_sd/sand_dirt_medium.tga			(main texture)
//3:	textures/capuzzo/rock.tga					(dirty texture...)
//4:	textures/desert_sd/rock_edged_smooth.tga			(mountain texture)
//5:	textures/desert_sd/grass_sand_flat.tga			(grass texture)
//6:	textures/egypt_walls_sd/debri_m05.tga
//7:  textures/temperate_sd/rock_graynoise.tga
//8:	textures/capuzzo/sand_patchnoise.tga			(Cave floor texture)

//Base shader:

textures/capuzzo_terrain/base_shader
{
	q3map_tcGen ivector ( 384 0 0 ) ( 0 384 0 )
	q3map_alphaMod dotproduct2 ( 0 0 2 )
	q3map_tcMod rotate 33

	q3map_noClip
	q3map_noTJunc

	q3map_nonplanar
	q3map_shadeAngle 179

	q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapsamplesize 8
	//q3map_lightmapaxis z
}

textures/capuzzo_terrain/base_shader_cave
{
	q3map_noClip
	q3map_noTJunc

	q3map_nonplanar
	q3map_shadeAngle 179

	//q3map_lightmapsize 512 512
	q3map_lightmapMergable
	q3map_lightmapsamplesize 8
	//q3map_lightmapaxis z
}

//***-***


//Single, non blending shaders:

textures/capuzzo_terrain/1 
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/desert_sd/sand_dirt_medium.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4.tga
	
	{
		map textures/desert_sd/rock_edged_smooth.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/4_cave
{
	q3map_baseshader textures/capuzzo_terrain/base_shader_cave
	qer_editorimage textures/desert_sd/rock_edged_smooth.tga

	{
		map textures/desert_sd/rock_edged_smooth.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/8
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_8.tga

	{
		map textures/capuzzo/sand_patchnoise.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

//***-***


//Dual, blending shaders:

textures/capuzzo_terrain/1_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1_to_4.tga
	
	{
		map textures/desert_sd/sand_dirt_medium.tga
		rgbGen identity
	}
	{
		map textures/desert_sd/rock_edged_smooth.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/1_to_8
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_1_to_8.tga
	
	{
		map textures/desert_sd/sand_dirt_medium.tga
		rgbGen identity
	}
	{
		map textures/capuzzo/sand_patchnoise.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/3_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_3_to_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	{
		map textures/capuzzo/rock.tga
		rgbGen identity
	}
	{
		map textures/desert_sd/sand_dirt_medium.tga	
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/4_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_4_to_1.tga
	
	{
		map textures/desert_sd/rock_edged_smooth.tga
		rgbGen identity
	}
	{
		map textures/desert_sd/sand_dirt_medium.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/5_to_1
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/capuzzo_terrain/pic_5_to_1.tga
	surfaceparm gravelsteps
	surfaceparm landmine

	{
		map textures/desert_sd/grass_sand_flat.tga	
		rgbGen identity
	}
	{
		map textures/desert_sd/sand_dirt_medium.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/6_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/egypt_walls_sd/debri_m05.tga
	
	{
		map textures/egypt_walls_sd/debri_m05.tga
		rgbGen identity
	}
	{
		map textures/desert_sd/rock_edged_smooth.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

textures/capuzzo_terrain/7_to_4
{
	q3map_baseshader textures/capuzzo_terrain/base_shader
	qer_editorimage textures/temperate_sd/rock_graynoise.tga
	
	{
		map textures/temperate_sd/rock_graynoise.tga
		rgbGen identity
	}
	{
		map textures/desert_sd/rock_edged_smooth.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		 
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		detail
		tcMod scale 4 4
	}
}

//***-***
