// ========================
//  braundorf_final.shader
// ========================

textures/braundorf/sky
{
	skyparms - 200 -
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	{
		map textures/braundorf/clouds.tga
		rgbGen identity
		tcmod scale 3 3
		tcMod scroll 0.0045 0.0035
	}
}

textures/braundorf/sign
{
	nomipmaps
	nopicmip
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm woodsteps
	implicitMap -
	{
		map textures/braundorf/sign.tga
	}
}

textures/braundorf/light
{
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/braundorf/light.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/braundorf/light.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/braundorf/rock2grass
{
	
	{
		map textures/braundorf/mountain.tga
		rgbGen identity
	}
	{
		map textures/braundorf/grass1.tga
		tcmod scale 2 2
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/mountain
{
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/braundorf/mountain.tga
		blendFunc filter
	}
}

textures/braundorf/grass2dirt
{
	surfaceparm grasssteps
 	surfaceparm landmine
	{
		map textures/braundorf/grass1.tga
		tcmod scale 2 2
		rgbGen identity
	}
	{
		map textures/braundorf/dirt1.tga
		tcmod scale 2 2
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/tree1
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/braundorf/tree2
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/braundorf/plant
{
	nopicmip
	cull twosided
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	implicitMask -
}

textures/braundorf/glass
{
	cull none
	surfaceparm alphashadow
	surfaceparm glass
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/common/dirtymirror2.tga
		blendfunc blend
		rgbGen identity
		depthWrite
	}
}

textures/braundorf/pave1
{
	{
		map textures/braundorf/pavement1.tga
		tcmod scale 8 8
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/pave2
{
	{
		map textures/braundorf/pavement2.tga
		tcmod scale 3 3
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/floor
{
	{
		map textures/braundorf/floor.tga
		tcmod scale 2 2
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/wall1
{
	{
		map textures/cathedrale_wall/cathedrale_c09.tga
		tcmod scale 1 2
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/ceiling
{
	{
		map textures/braundorf/wall_town1.tga
		tcmod scale 1 .5
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/awf1
{
	{
		map textures/effects/envmap_slate.tga
		rgbGen identity
		tcGen environment
	}
	{
		map textures/braundorf/awf.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/awf/awf_w_m10.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/awf2
{
	{
		map textures/effects/envmap_slate.tga
		rgbGen identity
		tcGen environment
	}
	{
		map textures/braundorf/awf.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/awf/awf_w_m11.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/braundorf/window
{
	{
		map textures/effects/envmap_slate.tga
		rgbGen identity
		tcGen environment
	}
	{
		map textures/braundorf/win.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/tobruk_windows_sd/tobruk_windows_off.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}