// Shaderfile for Enemy Territory custom map Berserk.
// By Loffy (Sweden), December 2003.

textures/berserk/terrain_base
{
	q3map_lightmapaxis z
	q3map_lightmapmergable
	q3map_lightmapsize 512 512
	q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	surfaceparm landmine
}


textures/berserktex/graes.tga
{
     qer_editorimage textures/berserktex/graes.tga
     surfaceparm landmine
     {
          map /textures/berserktex/graes.tga
     }
}

textures/berserktex/dirtbrun.tga
{
     qer_editorimage textures/berserktex/dirtbrun.tga
     surfaceparm landmine
     {
          map /textures/berserktex/dirtbrun.tga
     }
}

textures/berserktex/grasstig.tga
{
     qer_editorimage textures/berserktex/grasstig.tga
     surfaceparm landmine
     {
          map /textures/berserktex/grasstig.tga
     }
}


textures/berserk/terrain_0
{
	q3map_baseshader textures/berserk/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/berserktex/graes.tga
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_1
{
	q3map_baseshader textures/berserk/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/berserktex/rockgrav.tga
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_2
{
	q3map_baseshader textures/berserk/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/berserktex/dirtbrun.tga
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_3
{
	q3map_baseshader textures/berserk/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/berserktex/grasstig.tga
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_0to1
{
	q3map_baseshader textures/berserk/terrain_base
	{
		map textures/berserktex/graes.tga
		tcMod scale 2.0 2.0
	}
	{
		map textures/berserktex/rockgrav.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_0to2
{
	q3map_baseshader textures/berserk/terrain_base
	{
		map textures/berserktex/graes.tga
		tcMod scale 2.0 2.0
	}
	{
		map textures/berserktex/dirtbrun.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_0to3
{
	q3map_baseshader textures/berserk/terrain_base
	{
		map textures/berserktex/graes.tga
		tcMod scale 2.0 2.0
	}
	{
		map textures/berserktex/grasstig.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_1to2
{
	q3map_baseshader textures/berserk/terrain_base
	{
		map textures/berserktex/rockgrav.tga
		tcMod scale 2.0 2.0
	}
	{
		map textures/berserktex/dirtbrun.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_1to3
{
	q3map_baseshader textures/berserk/terrain_base
	{
		map textures/berserktex/rockgrav.tga
		tcMod scale 2.0 2.0
	}
	{
		map textures/berserktex/grasstig.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk/terrain_2to3
{
	q3map_baseshader textures/berserk/terrain_base
	{
		map textures/berserktex/dirtbrun.tga
		tcMod scale 2.0 2.0
	}
	{
		map textures/berserktex/grasstig.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


//----------------------------------------------------------------------------------------

// The family's cat Randi
textures/berserktex/randi_alpha
{
 cull none
 nopicmip
 {
 map textures/berserktex/randi_alpha.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}


textures/berserktex/storvit
{
	surfaceparm metalsteps
	implicitMap -
}

textures/berserktex/litenvit
{
	surfaceparm metalsteps
	implicitMap -
}

textures/berserktex/lysror
{
	surfaceparm metalsteps
	implicitMap -
}

// Banner, thanks to Drakir.
textures/berserktex/dr_banner
{
	qer_editorimage textures/berserktex/dr_banner.tga
	cull disable
	deformVertexes wave 100 sin 0 2 0 .3
	deformVertexes wave 30 sin 0 2 0 .1
	nofog
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	tessSize 64
	implicitMap textures/berserktex/dr_banner.tga
}


textures/berserktex/blaammo
{
	surfaceparm metalsteps
	implicitMap -
}


textures/berserktex/blahalsa
{
	surfaceparm metalsteps
	implicitMap -
}

textures/berserktex/birdynamnam2
{
 cull none
 nopicmip
 surfaceparm nonsolid
 surfaceparm nomarks
 {
 map textures/berserktex/birdynamnam2.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}

textures/berserktex/birdynamnam3
{
 cull none
 nopicmip
 surfaceparm nonsolid
 surfaceparm nomarks
 {
 map textures/berserktex/birdynamnam3.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}

textures/berserktex/hollyhocksalpha1
{
 cull none
 nopicmip
 {
 map textures/berserktex/hollyhocksalpha1.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}

// bush1 and dahlia3 were my first md3 models ever.
models/mapobjects/loffymodels/bush1
{
 cull none
 nopicmip
 {
 map models/mapobjects/loffymodels/bush1.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}

models/mapobjects/loffymodels/dahlia3
{
 cull none
 nopicmip
 {
 map models/mapobjects/loffymodels/dahlia3.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}

textures/berserktex/axistavla1
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/axistavla2
{
	surfaceparm woodsteps
	implicitMap -
}


// These textures Stone03c and 09b are made by Sock.
textures/egyptsoc_wall/stone03c
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/egyptsoc_wall/stone09b
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/berserktex/docsignleft1
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/docsignright1
{
	surfaceparm woodsteps
	implicitMap -
}

//-----------------------------------------------------------------------------------

//Light emmiting decale:
textures/berserktex/allies_flagga
{
 q3map_lightimage textures/berserktex/allies_flagga.tga
 qer_editorimage textures/berserktex/allies_flagga.tga
 q3map_surfacelight 3000
 polygonOffset
 sort 6
 surfaceparm glass
 {
 map $lightmap
 }
 {
 map textures/berserktex/allies_flagga.tga
 blendFunc GL_DST_COLOR GL_ZERO
 rgbgen identity
 }
 {
 map textures/berserktex/allies_flagga.tga
 blendFunc GL_ONE GL_ONE
 }
}


//Light emmiting decale:
textures/berserktex/numberFi1618red
{
 q3map_lightimage textures/berserktex/numberFi1618red.tga
 qer_editorimage textures/berserktex/numberFi1618red.tga
 q3map_surfacelight 3000
 polygonOffset
 sort 6
 surfaceparm glass
 {
 map $lightmap
 }
 {
 map textures/berserktex/numberFi1618red.tga
 blendFunc GL_DST_COLOR GL_ZERO
 rgbgen identity
 }
 {
 map textures/berserktex/numberFi1618red.tga
 blendFunc GL_ONE GL_ONE
 }
}

textures/berserktex/number1618
{
 surfaceparm nonsolid
 polygonOffset
 sort 6
 {
 map textures/berserktex/number1618.tga
 blendFunc GL_DST_COLOR GL_ZERO
 rgbGen vertex
 alphaGen vertex
 }
}
