textures/berlin/burn_med_mrk
{
	nopicmip
	polygonOffset
	{
		map textures/berlin/burn_med_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}

textures/berlin/debris
{
	qer_editorimage textures/rubble/debri_m01.tga

	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/rubble/debri_m01
}

textures/berlin/debris2
{
	qer_editorimage textures/rubble/debri_m05.tga

	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/rubble/debri_m05
}

textures/berlin/fence_bars
{
	qer_trans 0.85
	qer_editorimage textures/alpha/ladder.tga
	cull disable
	nomipmaps
	nopicmip

	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans

	implicitMask textures/alpha/ladder.tga
}

textures/berlin/fence_diamond
{
	qer_trans 0.85
	qer_editorimage textures/alpha/fence_m01.tga
	cull disable
	nomipmaps
	nopicmip

	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans

	implicitMask textures/alpha/fence_m01.tga
}

textures/berlin/flag_red
{
	cull disable
	nomipmaps
	nopicmip
	deformVertexes wave 100 sin 0 2 0 .3
	deformVertexes wave 30 sin 0 2 0 .1
//	nofog
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	tessSize 64
	implicitBlend -
}

textures/berlin/glass_mrk
{
	nopicmip
	polygonOffset
	{
		map textures/berlin/glass_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

textures/berlin/grate
{
	qer_editorimage textures/metals_sd/grate_b.tga

	surfaceparm metalsteps
	implicitMap textures/metals_sd/grate_b.tga
}

textures/berlin/gravel
{
	qer_editorimage textures/desert_sd/road_dirty_gravel

	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/desert_sd/road_dirty_gravel
}

textures/berlin/light1_off
{
	qer_editorimage textures/berlin/light1_off.tga
	implicitMap textures/lights/light_xlight_03.tga
}

textures/berlin/papers
{
	polygonOffset
	surfaceparm pointlight
	implicitBlend -
}

textures/berlin/picture1
{ 
	surfaceparm carpetsteps
	implicitMap -
}

textures/berlin/poster1
{
	polygonOffset
	surfaceparm nomarks
	surfaceparm pointlight
	implicitBlend -
}

textures/berlin/red_canvas
{
	cull disable
	deformVertexes wave 100 sin 0 2 0 .3
	deformVertexes wave 30 sin 0 2 0 .1
//	nofog
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	tessSize 64
	implicitMap -
}

textures/berlin/signalcolour
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/berlin/smokepuff_blue
{
	cull none
	entityMergable
	nofog
	{
		map textures/berlin/smokepuff_blue.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		tcMod rotate 75
	}
}

textures/berlin/smokepuff_red
{
	cull none
	entityMergable
	nofog
	{
		map textures/berlin/smokepuff_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		tcMod rotate 75
	}
}

textures/berlin/smokepuff_yellow
{
	cull none
	entityMergable
	nofog
	{
		map textures/berlin/smokepuff_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		tcMod rotate 75
	}
}

textures/berlin/snow_bright
{
	qer_editorimage textures/berlin/snow_alpha

	surfaceparm snowsteps
	surfaceparm landmine

//	Phong shading
 	q3map_nonplanar
 	q3map_shadeangle 90

	implicitMap textures/berlin/snow_alpha
}

textures/berlin/snow_dirty
{
	qer_editorimage textures/snow/s_dirt_m03i_2

	surfaceparm snowsteps
	surfaceparm landmine
	implicitMap textures/snow/s_dirt_m03i_2
}

textures/berlin/snow_grass
{
	qer_editorimage textures/snow_sd/s_grass_ml03b_big

	surfaceparm grasssteps
	surfaceparm landmine
	implicitMap textures/snow_sd/s_grass_ml03b_big
}

textures/berlin/snow_road
{
	qer_editorimage textures/snow_sd/snow_noisy

	surfaceparm snowsteps
	surfaceparm landmine
	implicitMap textures/snow_sd/snow_noisy
}

textures/berlin/snow_rubble
{
	qer_editorimage textures/snow_sd/mxrock4b_snow

	surfaceparm gravelsteps
	surfaceparm landmine
	implicitMap textures/snow_sd/mxrock4b_snow
}

textures/berlin/trainposter
{
	polygonOffset
	surfaceparm pointlight
	implicitBlend -
}

textures/berlin/wagon_water
{
	qer_editorimage textures/berlin/wagon_water.tga
	qer_trans 0.5
	q3map_globaltexture
	cull disable
//	deformVertexes wave 160 sin 0 10 0 .3
//	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm water
	tesssize 512
	waterfogvars ( 0.1 0.1 0.1 ) 512
	{
		map textures/berlin/wagon_water.tga
//		rgbgen wave sin .4 0 0 .5
		tcmod scale .2 .1
		tcmod scroll .003 .002
		fog on
	}
	{
		map textures/berlin/wagon_water2.tga
		blendFunc GL_src_alpha GL_ONE
		alphagen const .5
		tcmod scale .2 .2
		tcmod scroll -.003 -.002
	}
}

textures/berlin/window1
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/berlin/window1.tga
	
	{
		map textures/berlin/window_shine.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/berlin/window1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}

textures/berlin/window2
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/berlin/window2.tga
	
	{
		map textures/berlin/window_shine.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/berlin/window2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}

textures/berlin/window3
{
	surfaceparm glass
	surfaceparm playerclip
	polygonOffset
	cull disable
	qer_trans 0.75
	qer_editorimage textures/berlin/window3.tga
	
	{
		map textures/berlin/window_shine.tga
		tcGen environment
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
	{
		map textures/berlin/window3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		depthWrite
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
 		depthWrite
		rgbGen identity
	}
}

textures/berlin/wood_mrk
{
	nopicmip
	polygonOffset
	{
		map textures/berlin/wood_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
	{
		map textures/berlin/wood_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen vertex
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/berlin/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/berlin/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/berlin/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/berlin/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/berlin/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/berlin/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/berlin/snow_over_concrete1
{
      qer_editorimage textures/berlin/snow_over_concrete1.tga
	surfaceparm gravelsteps
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/miltary_wall/concrete_c07bcmp.tga	// Primary
		rgbGen identity
	}
	{
		map textures/berlin/snow_alpha.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/berlin/snow_over_gravel
{
      qer_editorimage textures/berlin/snow_over_gravel.tga
	surfaceparm gravelsteps
	surfaceparm landmine
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/desert_sd/road_dirty_gravel.tga	// Primary
		rgbGen identity
	}
	{
		map textures/berlin/snow_alpha.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/berlin/snow_over_marble
{
      qer_editorimage textures/berlin/snow_over_marble.tga
	surfaceparm gravelsteps
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/egypt_floor_sd/marblefloor_c04.tga	// Primary
		rgbGen identity
	}
	{
		map textures/berlin/snow_alpha.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}