// Shaderfile for Enemy Territory custom map ambition2.
// By Loffy (Sweden), 2012.


// Non-solid rubble
textures/ambition/debri
{
	qer_editorimage textures/ambition/debri.jpg
	surfaceparm nomarks
	surfaceparm nonsolid
	implicitMap textures/ambition/debri.jpg
}

// Non-solid metal
textures/metal_misc/darkredmetal_ns
{
	qer_editorimage textures/metal_misc/darkredmetal.tga
	surfaceparm nonsolid
	surfaceparm trans
	implicitMap textures/metal_misc/darkredmetal.tga
}

textures/metal_misc/yellowmetal_ns
{
	qer_editorimage textures/metal_misc/yellowmetal.tga
	surfaceparm nonsolid
	surfaceparm trans
	implicitMap textures/metal_misc/yellowmetal.tga
}



// shader from Splashdamage - - textures/alpha/barb_wire
docgoal
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm trans
	implicitMask -
}

// Levelshot-shader
levelshots/ambition2_cc_automap
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/ambition2_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/ambition2_cc_trans
{
	nopicmip
	nocompress
	nomipmaps
	{
		clampmap levelshots/ambition2_cc.tga
		blendfunc blend
		rgbGen identity
		alphaGen vertex
	}
}

//------------- These are the textures that I have used for the terrain -------

//textures/desert_sd/grass_desert_flat
//textures/desert_sd/road_dirty_gravel
//map textures/temperate_sd/rock_graynoise
//map textures/temperate_sd/grass_path1




// ---------------- Terrain shader starts here -----------------------
textures/berserk_te/terrain_base
{
	q3map_lightmapaxis z
	q3map_lightmapmergable
	q3map_lightmapsize 512 512
	//q3map_tcGen ivector ( 640 0 0 ) ( 0 640 0 )
	q3map_tcGen ivector ( 320 0 0 ) ( 0 320 0 )
	surfaceparm landmine
}


textures/berserk_te/terrain_0
{
	q3map_baseshader textures/berserk_te/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/grass_desert_flat.tga
		//tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_1
{
	q3map_baseshader textures/berserk_te/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/rock_graynoise.tga
		//tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_2
{
	q3map_baseshader textures/berserk_te/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/desert_sd/road_dirty_gravel.tga
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_3
{
	q3map_baseshader textures/berserk_te/terrain_base
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/grass_path1.tga
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_0to1
{
	q3map_baseshader textures/berserk_te/terrain_base
	{
		map textures/desert_sd/grass_desert_flat.tga
		// tcMod scale 2.0 2.0
	}
	{
		map textures/temperate_sd/rock_graynoise.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_0to2
{
	q3map_baseshader textures/berserk_te/terrain_base
	{
		map textures/desert_sd/grass_desert_flat.tga
		// tcMod scale 2.0 2.0
	}
	{
		map textures/desert_sd/road_dirty_gravel.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_0to3
{
	q3map_baseshader textures/berserk_te/terrain_base
	{
		map textures/desert_sd/grass_desert_flat.tga
		// tcMod scale 2.0 2.0
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_1to2
{
	q3map_baseshader textures/berserk_te/terrain_base
	{
		map textures/temperate_sd/rock_graynoise.tga
		// tcMod scale 2.0 2.0
	}
	{
		map textures/desert_sd/road_dirty_gravel.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_1to3
{
	q3map_baseshader textures/berserk_te/terrain_base
	{
		map textures/temperate_sd/rock_graynoise.tga
		// tcMod scale 2.0 2.0
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/berserk_te/terrain_2to3
{
	q3map_baseshader textures/berserk_te/terrain_base
	{
		map textures/desert_sd/road_dirty_gravel.tga
		// tcMod scale 2.0 2.0
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		// tcMod scale 2.0 2.0
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


//---------------- Terrain shader ends here-------------------------

// The family's cat Randi
textures/berserktex/randi_alpha
{
 cull none
 nopicmip
 {
 map textures/berserktex/randi_alpha.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}


// A couple of socks, copied from Fuel Dump (the large house near the Fuel).
textures/berserktex/sockz
{
 cull none
 nopicmip
 {
 map textures/berserktex/sockz.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}

textures/berserktex/loffywall
{
	nomipmaps
	nopicmip
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/axisspawn
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/berserkimage
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/oasispump
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/radardish
{
	surfaceparm woodsteps
	implicitMap -
}



textures/berserktex/storvit
{
	surfaceparm metalsteps
	implicitMap -
}

textures/berserktex/litenvit
{
	surfaceparm metalsteps
	implicitMap -
}

textures/berserktex/lysror
{
	surfaceparm metalsteps
	implicitMap -
}

// Banner, thanks to Drakir.
textures/berserktex/dr_banner
{
	qer_editorimage textures/berserktex/dr_banner.tga
	cull disable
	deformVertexes wave 100 sin 0 2 0 .3
	deformVertexes wave 30 sin 0 2 0 .1
	nofog
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm trans
	tessSize 64
	implicitMap textures/berserktex/dr_banner.tga
}


textures/berserktex/blaammo
{
	surfaceparm metalsteps
	implicitMap -
}


textures/berserktex/blahalsa
{
	surfaceparm metalsteps
	implicitMap -
}


textures/berserktex/hollyhocksalpha1
{
 cull none
 nopicmip
 {
 map textures/berserktex/hollyhocksalpha1.tga
 alphaFunc GE128
 depthWrite
 rgbGen vertex
 }
}


textures/berserktex/axistavla1
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/axistavla2
{
	surfaceparm woodsteps
	implicitMap -
}


// These textures Stone03c and 09b are made by Sock.
textures/egyptsoc_wall/stone03c
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/egyptsoc_wall/stone09b
{
	q3map_nonplanar
	q3map_shadeangle 90
	implicitMap -
}

textures/berserktex/docsignleft1
{
	surfaceparm woodsteps
	implicitMap -
}

textures/berserktex/docsignright1
{
	surfaceparm woodsteps
	implicitMap -
}

//-----------------------------------------------------------------------------------


textures/berserktex/allies_flagga2
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm metalsteps
	implicitMap -
}

textures/berserktex/axis_flagga2
{
	nopicmip
	nocompress
	nomipmaps
	surfaceparm metalsteps
	implicitMap -
}

