//======================================================================
// alps.shader
//
//======================================================================
// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
textures/alps/sky
{
	qer_editorimage textures/skies/fueldump_clouds.tga
	q3map_lightrgb 0.8 0.9 1.0
	q3map_skylight 85 3
	q3map_sun 1 .95 .9 200 150 45
	skyparms - 200 -
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	{
		map textures/skies/fueldump_clouds.tga
		rgbGen identity
	}
	{
		map textures/skies/fueldump_clouds.tga
		blendfunc blend
		rgbGen identity
		tcMod scroll 0.0005 0.00
		tcMod scale 2 1
	}
}

textures/alps/safetyglass
{
	qer_editorimage textures/common/s_glass.tga
	surfaceparm alphashadow
	surfaceparm glass
	surfaceparm trans
	qer_trans  0.5
	surfaceparm trans
	{
		map textures/common/s_glass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}


//======================================================================
// Base for metashaders
//======================================================================
textures/alps/terrain_base
{
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm landmine
	surfaceparm snowsteps
}

//======================================================================
// Metashader for both sides of the map
// _dirt: Slighty dirty snow
// _mud: Mud/dirt snow
// _snow: Clean white snow
// _rock: Snow crispy rock
// _floor: Cave floor
//======================================================================

textures/alps/terrain_snow
{
      qer_editorimage textures/stone/mxsnow3.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow3.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_snow_nolandmine
{
      qer_editorimage textures/stone/mxsnow3.tga
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm snowsteps
	{
		map textures/stone/mxsnow3.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_mud_nolandmine
{
      qer_editorimage textures/snow_sd/mxrock4b_snow.tga
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm snowsteps
	{
		map textures/snow_sd/mxrock4b_snow.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_snow_nosnowstep
{
      qer_editorimage textures/stone/mxsnow3.tga
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/stone/mxsnow3.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirt_nosnowstep
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/stone/mxsnow2.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_rock
{
      qer_editorimage textures/stone/mxrock3h_snow.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxrock3h_snow.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirt
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_mud
{
      qer_editorimage textures/snow_sd/mxrock4b_snow.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/snow_sd/mxrock4b_snow.tga
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcGen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/cave_floor
{
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm gravelsteps
	q3map_nonplanar
	q3map_shadeangle 60
	qer_editorimage textures/stone/mxrock1aa.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/stone/mxrock1aa.tga
		blendFunc filter
	}
}



textures/alps/terrain_snowtodirt
{
      qer_editorimage textures/stone/mxsnow3.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow3.tga
		rgbgen identity
	}
	{
		map textures/stone/mxsnow2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}


textures/alps/terrain_snowtorock
{
      qer_editorimage textures/stone/mxsnow3.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow3.tga
		rgbgen identity
	}
	{
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_snowtomud
{
      qer_editorimage textures/stone/mxsnow3.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow3.tga
		rgbgen identity
	}
	{
		map textures/snow_sd/mxrock4b_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_snowtocavefloor
{
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
      qer_editorimage textures/stone/mxsnow3.tga
	{
		map textures/stone/mxsnow3.tga
		rgbgen identity
	}
	{
		map textures/stone/mxrock1aa.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirttocavefloor
{
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
      qer_editorimage textures/stone/mxsnow2.tga
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map textures/stone/mxrock1aa.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirttorock
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrainvert_dirttorock
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 0 0 512 ) ( 0 512 512 )
	surfaceparm landmine
	surfaceparm snowsteps
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map textures/stone/mxrock3h_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirttomud
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map textures/snow_sd/mxrock4b_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirttomud_nolandmine
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_nonplanar
	q3map_shadeangle 90
	q3map_lightmapsampleoffset 8.0
	q3map_lightmapsize 512 512
	q3map_lightmapaxis z
	q3map_normalimage textures/sd_bumpmaps/normalmap_terrain.tga
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm snowsteps
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map textures/snow_sd/mxrock4b_snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_dirttosnow
{
      qer_editorimage textures/stone/mxsnow2.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxsnow2.tga
		rgbgen identity
	}
	{
		map textures/stone/mxsnow3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_rocktodirt
{
      qer_editorimage textures/stone/mxrock3h_snow.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxrock3h_snow.tga
		rgbgen identity
	}
	{
		map textures/stone/mxsnow2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

textures/alps/terrain_mudtodirt
{
      qer_editorimage textures/stone/mxrock4b_snow.tga
	q3map_baseshader textures/alps/terrain_base
	{
		map textures/stone/mxrock4b_snow.tga
		rgbgen identity
	}
	{
		map textures/stone/mxsnow2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		tcgen lightmap
		rgbgen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
		tcMod scale 5 5
		detail
	}
}

