//************************       *******************************
//*************************WATER********************************
//************************       *******************************
textures/alcatraz/blood2
{
	polygonOffset
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/alcatraz/blood3
{
	polygonOffset
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/alcatraz/blood4
{
	polygonOffset
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/alcatraz/blood5
{
	polygonOffset
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/alcatraz/watersplash
{
	qer_editorimage textures/liquids_sd/siwa_water.tga
      qer_trans .9
//	deformVertexes wave 1817 sin 0 2.5 0 0.15
// 	deformVertexes wave 517 sin 0 1.5 0 0.30
	nopicmip
	nocompress
	cull none
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.02 0.01 0 0.02
		alphaGen vertex
		tcMod turb 0 0.005 0 0.007
		tcmod scroll .001 -.002
	}
	{
		map textures/liquids_sd/siwa_water.tga 
		blendfunc blend
		alphaGen Vertex
	}

}
textures/alcatraz/sd_fog
{
	qer_editorimage textures/sfx/fog_grey1.tga
	
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm fog
	
	fogparms ( 0.4 0.4 0.4 ) 10192
}

// ocean fog water
textures/alcatraz/fog_water
{
	qer_editorimage textures/common/fog_water.tga
	surfaceparm nodraw
  	surfaceparm nonsolid
  	surfaceparm trans
  	surfaceparm water
}

// abstract shader for subclassed shaders
textures/alcatraz/ocean_base
{
	qer_editorimage textures/liquids_sd/siwa_water.tga
	qer_trans 0.75
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_globalTexture
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm lightfilter
	surfaceparm pointlight
	nopicmip
}

// nonsolid terrain shader
textures/alcatraz/ocean_terrain
{
	qer_editorimage textures/common/terrain_nonsolid.tga
	q3map_terrain
	qer_trans .5
	surfaceparm nodraw
  	surfaceparm nonsolid
  	surfaceparm trans
  	nopicmip
  	
}

// subclassed ocean shaders
textures/alcatraz/ocean_0
{
	q3map_baseshader textures/alcatraz/ocean_base
	qer_editorimage textures/liquids_sd/siwa_water.tga
	cull none
	deformVertexes wave 1317 sin 0 2.5 0 0.15
 	deformVertexes wave 317 sin 0 1.5 0 0.30
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
		
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const 0.8
		tcmod scroll 0.03 0.005 
	}
	
}

textures/alcatraz/ocean_1
{
	q3map_baseshader textures/alcatraz/ocean_base
	qer_editorimage textures/liquids_sd/siwa_water.tga
	cull none
	deformVertexes wave 1317 sin 0 2.5 0 0.15
 	deformVertexes wave 317 sin 0 1.5 0 0.30
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .8
		tcmod scroll 0.005 0.03

	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 0.05 0 0.15
		tcmod scroll 0.08 -0.01 
	}
	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.15 0.1 0.1 0.15
		alphaGen vertex
		tcMod turb 0 0.05 0.5 0.15
		tcmod scroll 0.09 0.01 
	}
	
}

textures/alcatraz/ocean_0to1
{
	q3map_baseshader textures/alcatraz/ocean_base
	qer_editorimage textures/liquids_sd/siwa_water.tga
	cull none
	deformVertexes wave 1317 sin 0 2.5 0 0.15
 	deformVertexes wave 317 sin 0 1.5 0 0.30 	
	
	{
		map textures/liquids_sd/seawall_specular.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcGen environment
		depthWrite
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .8
		tcmod scroll 0.005 0.03  
	}
	{
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 0.05 0 0.15
		tcmod scroll 0.08 -0.01   
	}
	{ 
		map textures/liquids_sd/seawall_foam.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.15 0.1 0.1 0.15
		alphaGen vertex
		tcMod turb 0 0.05 0.5 0.15
		tcmod scroll 0.09 0.01 
	}
	
}

//************************       *******************************
//********************** COMMON_SP *****************************
//************************       *******************************
textures/alcatraz/clipweap
{
	qer_editorimage textures/common/ai_nosight.tga
	qer_trans 0.3
	surfaceparm nodraw
	surfaceparm nomarks
	surfaceparm trans
	surfaceparm slick
}

//************************       *******************************
//************************TERRAIN*******************************
//************************       *******************************
models/alcatraz/grass_foliage1
{
	qer_editorimage models/foliage/grassfoliage1.tga
	nopicmip
	qer_alphafunc greater 0.5
	cull disable

	// distanceCull <inner> <outer> <alpha threshold>
	distanceCull 512 1792 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grassfoliage1.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

models/alcatraz/grass_foliage2
{
	qer_editorimage models/foliage/grassfoliage2.tga
	nopicmip
	qer_alphafunc greater 0.5
	cull disable

	// distanceCull <inner> <outer> <alpha threshold>
	distanceCull 512 1536 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grassfoliage2.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

models/alcatraz/grass_foliage3
{
	qer_editorimage models/foliage/grassfoliage3.tga
	nopicmip
	qer_alphafunc greater 0.5
	cull disable

	// distanceCull <inner> <outer> <alpha threshold>
	distanceCull 480 1280 0.49
	sort seethrough
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	{
		map models/foliage/grassfoliage3.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

textures/alcatraz/base
{
	q3map_lightmapaxis z
	q3map_lightmapmergable
	q3map_lightmapsize 512 512

	q3map_nonplanar
	q3map_shadeangle 179	
//	q3map_forcemeta

//	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	tcmod scale 0.080000001 0.080000001
//	surfaceparm pointlight

}

//	q3map_baseshader textures/alcatraz/terrain_foliage_base
//	q3map_baseshader textures/alcatraz/terrain_foliage_fade

textures/alcatraz/terrain_foliage_base
{
	q3map_baseShader textures/alcatraz/base

	q3map_foliage models/alcatraz/grass_foliage1.md3 1.1 48 0.1 2
	q3map_foliage models/alcatraz/grass_foliage2.md3 1 48 0.1 2
	q3map_foliage models/alcatraz/grass_foliage3.md3 0.8 48 0.1 2
}

textures/alcatraz/terrain_foliage_fade
{
	q3map_baseShader textures/alcatraz/base

	q3map_foliage models/alcatraz/grass_foliage1.md3 1.1 64 0.1 2
	q3map_foliage models/alcatraz/grass_foliage2.md3 1 64 0.1 2
	q3map_foliage models/alcatraz/grass_foliage3.md3 0.8 64 0.1 2
}

textures/alcatraz/terrain_0
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map textures/temperate_sd/dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_1
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm slick
	{
		map textures/temperate_sd/rock_grayvar.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_2
{
	q3map_baseshader textures/alcatraz/terrain_foliage_fade
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_3
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_path1.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_4
{
	q3map_baseshader textures/alcatraz/terrain_foliage_base
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_dense1.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_0to1
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/rock_grayvar.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_0to2
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map textures/temperate_sd/dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_0to3
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map textures/temperate_sd/dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_0to4
{
	q3map_baseShader textures/alcatraz/base
	surfaceparm gravelsteps
	surfaceparm landmine
	{
		map textures/temperate_sd/dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_1to2
{
	q3map_baseShader textures/alcatraz/base
	{
		map textures/temperate_sd/rock_grayvar.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_1to3
{
	q3map_baseShader textures/alcatraz/base
	{
		map textures/temperate_sd/rock_grayvar.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_1to4
{
	q3map_baseShader textures/alcatraz/base
	{
		map textures/temperate_sd/rock_grayvar.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_2to3
{
	q3map_baseshader textures/alcatraz/terrain_foliage_base
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_path1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_2to4
{
	q3map_baseshader textures/alcatraz/terrain_foliage_base
	surfaceparm grasssteps
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/terrain_3to4
{
	q3map_baseshader textures/alcatraz/terrain_foliage_fade
	surfaceparm grasssteps
	{
		map textures/temperate_sd/grass_path1.tga
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map textures/temperate_sd/grass_dense1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		tcmod scale 0.080000001 0.080000001
		rgbgen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbgen identity
	}
}

textures/alcatraz/ladder
{
	cull disable
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/alcatraz/crack
{
	cull disable
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	nopicmip
	implicitMask -
}

textures/alcatraz/truss_m06a
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/alcatraz/truss_m06r
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/alcatraz/door_m04_sp
{
	qer_editorimage textures/alcatraz/door_m04.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/alcatraz/door_m04.tga
}

textures/alcatraz/door_m04
{
	q3map_nonplanar
	q3map_shadeangle 90
	surfaceparm metalsteps
	implicitMap -
}

textures/alcatraz/ammosign
{
	qer_editorimage textures/alcatraz/ammosign.tga
	surfaceparm nomarks
	q3map_surfacelight 20
	polygonoffset
	nomipmaps
	nopicmip
	{
		map textures/alcatraz/ammosign.tga
		blendfunc blend
		rgbGen Vertex
		alphaGen Vertex
	}
}

textures/alcatraz/medicsign
{
	qer_editorimage textures/alcatraz/medicsign.tga
	surfaceparm nomarks
	q3map_surfacelight 20
	polygonoffset
	nomipmaps
	nopicmip
	{
		map textures/alcatraz/medicsign.tga
		blendfunc blend
		rgbGen Vertex
		alphaGen Vertex
	}
}

textures/alcatraz/red
{
	qer_editorimage textures/alcatraz/red.tga
	cull none
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/alcatraz/red.tga
		blendfunc add
		rgbGen wave sin 0 1 0.9 0.7 
	}
}


//************************       *******************************
//************************ MODEL *******************************
//************************       *******************************
models/mapobjects/dt_aa_mm/dt_aatool
{
	qer_editorimage models/mapobjects/dt_aa_mm/dt_aatool.tga
	{
			map textures/effects/envmap_slate_90.tga
	         	rgbGen vertex
	         	tcGen environment
	}
	{
	         	map models/mapobjects/dt_aa_mm/dt_aatool.tga
	         	blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
	         	rgbGen vertex
	}
}

models/mapobjects/dt_aa_mm/dt_aatool_alpha
{
	qer_editorimage models/mapobjects/dt_aa_mm/dt_aatool.tga
	nopicmip
	nomipmap
	cull twosided
	implicitMask models/mapobjects/dt_aa_mm/dt_aatool.tga
}

//**************************************
//******* SHIP *************************
//**************************************
textures/alcatraz/boataxis/fishnet
{
	qer_trans 0.85
	qer_editorimage models/alcatraz/boataxis/fishnet.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/alcatraz/boataxis/fishnet.tga
}

textures/alcatraz/boataxis/axisflag
{
	qer_editorimage models/alcatraz/boataxis/axisflag.jpg
	cull none
	surfaceparm nomarks
      surfaceparm noimpact
	surfaceparm nonsolid
	implicitmap  models/alcatraz/boataxis/axisflag.jpg 
}


textures/alcatraz/boataxis/shipcammo
{
	qer_editorimage models/alcatraz/boataxis/shipcammo.jpg
	q3map_nonplanar 
	q3map_shadeangle 135
	implicitmap models/alcatraz/boataxis/shipcammo.jpg
}

textures/alcatraz/boataxis/shipwindow
{
	qer_editorimage models/alcatraz/boataxis/shipwindow.jpg
	implicitmap models/alcatraz/boataxis/shipwindow.jpg
}

textures/alcatraz/boataxis/shipdoor
{
	qer_editorimage models/alcatraz/boataxis/shipdoor.jpg
	implicitmap models/alcatraz/boataxis/shipdoor.jpg
}

textures/alcatraz/boataxis/shipvent
{
	qer_editorimage models/alcatraz/boataxis/shipvent.jpg
	implicitmap models/alcatraz/boataxis/shipvent.jpg
}

textures/alcatraz/boataxis/shipgunmetal
{
	qer_editorimage models/alcatraz/boataxis/shipgunmetal.jpg
	implicitmap models/alcatraz/boataxis/shipgunmetal.jpg
}

textures/alcatraz/boataxis/shipgunmetal2
{
	qer_editorimage models/alcatraz/boataxis/shipgunmetal2.jpg
	implicitmap models/alcatraz/boataxis/shipgunmetal2.jpg
}

textures/alcatraz/boataxis/shipgun
{
	qer_editorimage models/alcatraz/boataxis/shipgun.jpg
	implicitmap models/alcatraz/boataxis/shipgun.jpg
}

textures/alcatraz/boataxis/shipmetal
{
	qer_editorimage models/alcatraz/boataxis/shipmetal.jpg
	implicitmap models/alcatraz/boataxis/shipmetal.jpg
}

//**************************************
//*******        fence         *********
//**************************************
models/mapobjects/br_chainlink/br_fence1
{
	qer_editorimage models/mapobjects/br_chainlink/br_fence1.tga
	implicitmap models/mapobjects/br_chainlink/br_fence1.tga
}

models/mapobjects/br_chainlink/br_fence2
{
	qer_trans 0.85
	qer_editorimage models/mapobjects/br_chainlink/br_fence2.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/mapobjects/br_chainlink/br_fence2.tga

}

models/mapobjects/br_chainlink/br_wire1
{
	qer_trans 0.85
	qer_editorimage models/mapobjects/br_chainlink/br_wire1.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/mapobjects/br_chainlink/br_wire1.tga

}

//**************************************
//*******          ship        *********
//**************************************
models/alcatraz/boataxis/br_ship1
{
	qer_editorimage models/alcatraz/boataxis/br_ship1.tga
	implicitmap models/alcatraz/boataxis/br_ship1.tga
}
models/alcatraz/boataxis/br_ship2
{
	qer_editorimage models/alcatraz/boataxis/br_ship2.tga
	implicitmap models/alcatraz/boataxis/br_ship2.tga
}
models/alcatraz/boataxis/br_ship3
{
	qer_editorimage models/alcatraz/boataxis/br_ship3.tga
	implicitmap models/alcatraz/boataxis/br_ship3.tga
}
models/alcatraz/boataxis/br_ship4
{
	qer_editorimage models/alcatraz/boataxis/br_ship4.tga
	implicitmap models/alcatraz/boataxis/br_ship4.tga
}
models/alcatraz/boataxis/br_ship5
{
	qer_editorimage models/alcatraz/boataxis/br_ship5.tga
	implicitmap models/alcatraz/boataxis/br_ship5.tga
}
models/alcatraz/boataxis/br_ship6
{
	qer_editorimage models/alcatraz/boataxis/br_ship6.tga
	implicitmap models/alcatraz/boataxis/br_ship6.tga
}
models/alcatraz/boataxis/br_ship7
{
	qer_editorimage models/alcatraz/boataxis/br_ship7.tga
	implicitmap models/alcatraz/boataxis/br_ship7.tga
}
models/alcatraz/boataxis/br_sail2
{
	qer_editorimage models/alcatraz/boataxis/br_sail2.tga
	nopicmip
	nomipmap
	cull twosided
	implicitmap models/alcatraz/boataxis/br_sail2.tga
}
models/alcatraz/boataxis/br_sail1
{
	qer_editorimage models/alcatraz/boataxis/br_sail1.tga
	nopicmip
	nomipmap
	cull twosided
	implicitmap models/alcatraz/boataxis/br_sail1.tga
}
models/alcatraz/boataxis/br_flag1
{
	qer_editorimage models/alcatraz/boataxis/br_flag1.tga
	nopicmip
	nomipmap
	implicitmap models/alcatraz/boataxis/br_flag1.tga
}
//**************************************
//*******        CAMERA        *********
//**************************************
models/alcatraz/Videocamera/videocamerasupport
{
    cull disable
    surfaceparm alphashadow
        {
                map models/alcatraz/Videocamera/videocamerasupport.tga
                alphaFunc GE128
		depthWrite
		rgbGen vertex
        }
}


//**************************************
//*******        SKEL          *********
//**************************************
models/alcatraz/skel/skel
{
	cull disable
	surfaceparm alphashadow
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	implicitMask models/alcatraz/skel/skel.tga
}

//**************************************
//*******    vendingmachines   *********
//**************************************
models/mapobjects/br_vendingmachines/br_vending1
{
	qer_editorimage models/mapobjects/br_vendingmachines/br_vending1.tga
	q3map_surfacelight 100
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitmap models/mapobjects/br_vendingmachines/br_vending1.tga
}
models/mapobjects/br_vendingmachines/br_vending2
{
	qer_editorimage models/mapobjects/br_vendingmachines/br_vending2.tga
	q3map_surfacelight 100
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitmap models/mapobjects/br_vendingmachines/br_vending2.tga
}
models/mapobjects/br_vendingmachines/br_vending22
{
	q3map_surfacelight 100
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitMask -
}

models/mapobjects/br_vendingmachines/br_vending3
{
	q3map_surfacelight 100
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	nopicmip
	implicitMask -
}

models/mapobjects/br_vendingmachines/br_vending4
{
	qer_editorimage models/mapobjects/br_vendingmachines/br_vending4.tga
	q3map_surfacelight 100
	nopicmip
	implicitmap models/mapobjects/br_vendingmachines/br_vending4.tga
}


//**************************************
//*******      red  trans      *********
//*******      keyjailred      *********
//**************************************
models/alcatraz/key/sp_red
{
	qer_editorimage textures/common/dirtymirror.tga
	surfaceparm trans
	surfaceparm pointlight
	cull disable
	{
		map models/alcatraz/key/b.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 0.5 
		tcGen environment 
	}
	{
		map models/alcatraz/key/r.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 0.1 
		tcGen environment 
	}
	{
		map models/alcatraz/key/g.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 0.05 
		tcGen environment 
	}
}

//**************************************
//*******         RELIC        *********
//*******          VIP         *********
//**************************************
models/alcatraz/hostage/hair
{
	qer_editorimage models/alcatraz/hostage/hair.tga
	surfaceparm nomarks
	{
		map models/alcatraz/hostage/hair.tga
		rgbGen lightingDiffuse
	}
}

models/alcatraz/hostage/head
{
	qer_editorimage models/alcatraz/hostage/head.tga
	surfaceparm nomarks
	{
		map models/alcatraz/hostage/head.tga
		rgbGen lightingDiffuse
	}
}

models/alcatraz/hostage/lower
{
	qer_editorimage models/alcatraz/hostage/lower.tga
	surfaceparm nomarks
	{
		map models/alcatraz/hostage/lower.tga
		rgbGen lightingDiffuse
	}
}

models/alcatraz/hostage/upper
{
	qer_editorimage models/alcatraz/hostage/upper.tga
	surfaceparm nomarks
	{
		map models/alcatraz/hostage/upper.tga
		rgbGen lightingDiffuse
	}
}
//**************************************
//*******       SIGNATURE      *********
//**************************************
textures/signature/speaker2
{
	surfaceparm woodsteps
	implicitMap -
}
textures/signature/stereo2
{
	surfaceparm woodsteps
	implicitMap -
}
textures/signature/potleaf1
{
	qer_editorimage textures/signature/potleaf1.tga
	DeformVertexes autosprite2
	surfaceparm nodamage
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
//	{
//		map textures/signature/potleaf1.tga
	//	blendFunc GL_SRC_ALPHA GL_ONE
//		alphaFunc GE128
		//rgbGen wave noise 0.75 0.25 0 10
//		rgbgen identity
//	alphaFunc GE128
//	}
//	{
//		map $lightmap
 //       	blendfunc gl_dst_color gl_zero

//	}
}
textures/signature/signature_alcatraz
{
	qer_editorimage textures/signature/signature_alcatraz.tga
	surfaceparm noimpact
	surfaceparm nolightmap
			
	{
		map textures/signature/signature_alcatraz.tga
		tcMod scroll 0 0.022
		rgbGen const ( 0.9 0.9 0.9 )
	}
}

textures/signature/signature_alcatraz_b3
{
	qer_editorimage textures/signature/signature_alcatraz_b3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
			
	{
		map textures/signature/signature_alcatraz_b3.tga
		tcMod scroll 0 0.022
		rgbGen const ( 0.9 0.9 0.9 )
	}
}



// bus dri
models/jailbus_dri/sign
{
	qer_editorimage models/jailbus_dri/sign.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm pointlight
	implicitBlend models/jailbus_dri/sign.tga
}

models/jailbus_dri/textures
{
    	qer_editorimage models/jailbus_dri/textures.tga
	nomipmaps
	nopicmip
	surfaceparm pointlight
	implicitBlend models/jailbus_dri/textures.tga
}

textures/driclan/drilogo
{
	qer_editorimage textures/driclan/drilogo.tga
	polygonoffset
	surfaceparm pointlight
	implicitBlend -
//	nomipmaps
//	nopicmip
//	{
//		map textures/driclan/drilogo.tga
//		blendfunc blend
//		rgbGen Vertex
//		alphaGen Vertex
//	}
}

textures/driclan/logogreen0000_sp
{
	qer_editorimage textures/driclan/logogreen0000.tga
	polygonoffset
	{
		map textures/driclan/logogreen0000.tga
		blendfunc blend
		rgbGen Vertex
		alphaGen Vertex
	}
}

textures/driclan/logogirl0000_sp
{
	qer_editorimage textures/driclan/logogirl0000.tga
	polygonoffset
	{
		map textures/driclan/logogirl0000.tga
		blendfunc blend
		rgbGen Vertex
		alphaGen Vertex
	}
}

textures/driclan/dribanner
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/logogirl0000
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/drilogo_def
{
	qer_editorimage textures/driclan/drilogo.tga
	surfaceparm woodsteps
	implicitMap textures/driclan/drilogo.tga
}

textures/driclan/drilogo_b_and_w
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/dribanner2
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/logogreen0000
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/logodri_20000
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/image1
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/dri_emblem
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/dri_emblem_mask
{
     qer_editorimage textures/driclan/dri_emblem_mask.tga
	polygonoffset
      surfaceparm nomarks
     	implicitMask textures/driclan/dri_emblem_mask.tga
}

textures/driclan/mascot
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/banner1024
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/banner1024_tag
{
     qer_editorimage textures/driclan/banner1024_tag.tga
	polygonoffset
      surfaceparm nomarks
     	implicitMask textures/driclan/banner1024_tag.tga
}

textures/driclan/logotype
{
	surfaceparm woodsteps
	implicitMap -
}


textures/driclan/banner1024_2
{
	surfaceparm woodsteps
	implicitMap -
}

textures/driclan/banner1024_mask
{
	qer_editorimage textures/driclan/banner1024_mask.tga
//	polygonoffset
	surfaceparm trans
      surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
//	cull twosided
	deformVertexes wave 5 sin 0 1 0 .1
	implicitMask -
}

textures/driclan/flags_dri
{
	qer_editorimage textures/driclan/flags_dri.tga
//	polygonoffset
	surfaceparm trans
      surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	cull twosided
	deformVertexes wave 5 sin 0 1 0 .1
	implicitMask -
}

models/mapobjects/cmarker/c_box_allieddri
{
	qer_editorimage models/mapobjects/cmarker/allied_cratedri.tga
	implicitMap models/mapobjects/cmarker/allied_cratedri.tga
}

models/mapobjects/cmarker/c_box_axisdri
{
	qer_editorimage models/mapobjects/cmarker/axis_cratedri.tga
	implicitMap models/mapobjects/cmarker/axis_cratedri.tga
}

models/mapobjects/cmarker/cflag_allieddri
{
	qer_editorimage models/mapobjects/cmarker/cflagallieddri.tga
	cull disable
	deformVertexes wave 194 sin 0 3 0 .4
	implicitMask models/mapobjects/cmarker/cflagallieddri.tga
}

models/mapobjects/cmarker/cflag_axisdri
{
	qer_editorimage models/mapobjects/cmarker/cflagaxisdri.tga
	cull disable
	deformVertexes wave 194 sin 0 3 0 .4
	implicitMask models/mapobjects/cmarker/cflagaxisdri.tga
}

models/mapobjects/radios_sd/allied_signdri

{
     qer_editorimage models/mapobjects/radios_sd/allied_signdri.tga
	polygonoffset
      surfaceparm nomarks
     	implicitMask models/mapobjects/radios_sd/allied_signdri.tga
}

models/mapobjects/radios_sd/neutral_signdri

{
	qer_editorimage models/mapobjects/radios_sd/neutral_signdri.tga
	surfaceparm nomarks
     	implicitMask models/mapobjects/radios_sd/neutral_signdri.tga
}

models/mapobjects/radios_sd/axis_signdri

{
     qer_editorimage models/mapobjects/radios_sd/axis_signdri.tga
	polygonoffset
      surfaceparm nomarks
     	implicitMask models/mapobjects/radios_sd/axis_signdri.tga
}

