// Shader for Fidels ET Map
// by fidel castro
// www.fidel.vido.info
//
//
// Overview 
//********************
// - China Papier NEU
// - SFX fr obj.
// - Sky
// - Terrain lightmapped test
// - Phong
// - Lichtquellen
// - Fahne
// - Glas
// - Glhwrmer, 	thx Pazifist
// - Fliegen, 	thx Pazifist
// - Alphas
// - Custom Modelle
// - Normalmaps
//********************



//////////////////////////
// China PApier NEU


textures/fid_china/mic_papier01
{	cull disable
	//surfaceparm alphashadow
	qer_editorimage textures/fid_china/mic_detail01.tga
	q3map_lightfilter
	surfaceparm trans
	//sort 6
	{
		map textures/fid_china/mic_detail01.tga
		blendFunc add
		rgbGen identity
	}
	{
		map textures/fid_china/mic_layer01.tga
		blendFunc filter
		tcmod scale 0.25 0.25
		rgbGen identity
	}
	{
		map $lightmap
		blendfunc gl_dst_color gl_zero
		rgbGen identity
	}
}




textures/fid_china/mic_papier02
{	cull disable
	//surfaceparm alphashadow
	qer_editorimage textures/fid_china/mic_detail01.tga
	q3map_lightfilter
	surfaceparm trans
	//sort 6
	{
		map textures/fid_china/mic_detail01.tga
		blendFunc add
		rgbGen identity
	}
	{
		map textures/fid_china/mic_layer02.tga
		blendFunc filter
		tcmod scale 0.25 0.25
		rgbGen identity
	}
	{
		map $lightmap
		blendfunc gl_dst_color gl_zero
		rgbGen identity
	}
}







///////////////////////////
// SFX fr obj.
//

textures/fid_china/sfx_blue
{
	qer_editorimage textures/fid_china/pb_lanz_proto_blue.tga
	q3map_backsplash 0 0	// Avoid point source lighting on face
	q3map_surfacelight 100
	q3map_lightsubdivide 64	// Finer subdevision
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	{
		map textures/fid_china/pb_lanz_proto_blue.tga
		tcGen environment
        	tcMod turb 0 0.1 0 0.1
        	tcmod scroll .1 .1
		blendfunc GL_ONE GL_ONE
	}
}


textures/fid_china/sfx_red
{
	qer_editorimage textures/fid_china/pb_lanz_proto_red.tga
	q3map_backsplash 0 0	// Avoid point source lighting on face
	q3map_surfacelight 100
	q3map_lightsubdivide 64	// Finer subdevision
	surfaceparm nolightmap
	surfaceparm nonsolid
	surfaceparm trans
	{
		map textures/fid_china/pb_lanz_proto_red.tga
		tcGen environment
        	tcMod turb 0 0.1 0 0.1
        	tcmod scroll .1 .1
		blendfunc GL_ONE GL_ONE
	}
}









/////////////////////////
// Sky
//
// not in use

textures/fid_china/fid_skybox
{
  qer_editorimage textures/fid_china/blizzard512_rt.tga
  surfaceparm noimpact
  surfaceparm sky
  surfaceparm nolightmap

  q3map_sun 1.0 1.0 0.8 75 225 45
  skyparms textures/fid_china/blizzard - -

  {
    map textures/fid_china/blizzard512_rt.tga
    blendFunc GL_ONE GL_ONE
    tcMod scroll 0.02 0.01
    tcMod scale 3 3
  }
}







////////////////////////
// Lightmapped Terrain
//
// not in use








////////////////////////////////////////////////
// Phong frs terrain
//

//schnee
//
textures/fid_china/fid_phong
{
q3map_nonplanar // unebene Oberflche
q3map_shadeangle 60 // Unser Glttungswinkel
qer_editorimage textures/fid_china/fid_snow_terrain_p.tga
{
map $lightmap // Der berhmte Lightmapstage
rgbGen identity
}
{
map textures/fid_china/fid_snow_terrain.tga
blendFunc filter
}
}



//felsen
//
textures/fid_china/fid_phong_fels
{
q3map_nonplanar // unebene Oberflche
q3map_shadeangle 60 // Unser Glttungswinkel
qer_editorimage textures/fid_china/fid_snow_rocks_p.tga
{
map $lightmap // Der berhmte Lightmapstage
rgbGen identity
}
{
map textures/fid_china/fid_snow_rocks.tga
blendFunc filter
}
}








/////////////////////////////////////////////////////
// LICHT-QUELLEN
//

//Lichtstrahlen a la mindlink
//
textures/fid_china/beam_licht
{
	qer_editorimage textures/fid_china/fid_beam.tga
	nocompress
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/fid_china/fid_beam.tga
		blendFunc add
		tcmod scroll -0.03 -0.05
//		q3map_tcMod scale 0.0625 0.0625
	}
}


//Reispapier ohne Licht
//
textures/fid_china/fid_reispapier_1_OHNE_emission
{
	qer_editorimage textures/fid_china/fid_reispapier_1.tga
	nocompress
	surfaceparm nomarks
	surfaceparm pointlight
	{
		map textures/fid_china/fid_reispapier_1.tga
		blendFunc add
	}
}


//Reispapier mit Licht
//
textures/fid_china/fid_reispapier_1_emission
{
	qer_editorimage textures/fid_china/fid_reispapier_1.tga
	nocompress
	q3map_surfacelight 20
	surfaceparm nomarks
	surfaceparm pointlight
	{
		map textures/fid_china/fid_reispapier_1.tga
		blendFunc add
	}
}





/////////////////////////////////////////////////////
//Fahne
//

textures/fid_china/fid_flags_snow
{
//	surfaceparm nolightmap // added as test
//	surfaceparm trans // added as test
	surfaceparm alphashadow
	deformVertexes wave 10 sin 0 2 0 .2
	cull twosided
	{
		map textures/fid_china/fid_flag_snow.tga
		alphafunc ge128		
		rgbGen vertex
	}
	{
		map $lightmap
		blendfunc gl_zero gl_one
		rgbgen identity
		depthfunc equal
	}

}






/////////////////////////////////////////////////////
// Glass Projektion
// out of realistic textur pack

textures/fid_china/glassprojektion 
{
     qer_editorimage textures/fid_china/fid_stainedglass.jpg
     surfaceparm trans 
     cull none
     surfaceparm lightfilter
     qer_trans 0.6 

{
           map textures/fid_china/fid_stainedglass.jpg
           blendfunc gl_dst_color gl_zero 
     }
}








//////////////////////////////////////////////////////////
// Gluehwrmer idee von pazifist
//

textures/fid_china/fid_gluehwuerm_1X_move
{	
	qer_editorimage textures/fid_china/gluehwuermchens.tga
      surfaceparm trans	
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	surfaceparm alphashadow
	
	qer_trans .5
	//tessSize 4
	deformVertexes autosprite
	deformVertexes move 30 30.3 0  sin 0 5 0 0.1
        
	cull none
        //nopicmip     
	{
		map textures/fid_china/gluehwuermchens.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll .2 -0.1
                tcMod turb .2 .17 0 -.3
                rgbGen wave triangle 0.5 0.3 0 .9
                blendFunc GL_ONE GL_ONE
        }
        {
		map textures/fid_china/gluehwuermchens02.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll .2 -0.1
                tcMod turb .2 .17 0 -.3
                rgbGen wave triangle 0.5 0.3 0 .7
                blendFunc GL_ONE GL_ONE
        }
}


textures/fid_china/fid_gluehwuerm__still
{	
	qer_editorimage textures/fid_china/gluehwuermchens.tga
      surfaceparm trans	
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	
	qer_trans .5
	//tessSize 4
	deformVertexes autosprite
 
	cull none
        //nopicmip
          
	{
		map textures/fid_china/gluehwuermchens.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll .2 -0.1
                tcMod turb .2 .17 0 -.3
                rgbGen wave triangle 0.5 0.3 0 .9
                blendFunc GL_ONE GL_ONE
        }
        {
		map textures/fid_china/gluehwuermchens02.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll .2 -0.1
                tcMod turb .2 .17 0 -.3
                rgbGen wave triangle 0.5 0.3 0 .7
                blendFunc GL_ONE GL_ONE
        }
}


textures/fid_china/fid_gluehwuerm_2X_move
{	
	qer_editorimage textures/fid_china/gluehwuermchens02.tga
      surfaceparm trans	
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	
	qer_trans .5
	//tessSize 4
	deformVertexes autosprite
 
	cull none
      //nopicmip
 
	{
		map textures/fid_china/gluehwuermchens03.tga
               
                tcMod Scroll .1 0.1
                tcMod turb .3 .1 0 -.2
                rgbGen wave triangle 0.5 0.3 0 1
                blendFunc GL_ONE GL_ONE
        }
        {
		map textures/fid_china/gluehwuermchens02.tga
                
                tcMod Scroll .2 0.1
                tcMod turb .2 .17 0 -.3
                rgbGen wave triangle 0.5 0.3 0 2.2
                blendFunc GL_ONE GL_ONE
        }
}



////////////////////////////////////////////
//  Fliege
//

textures/fid_china/fid_fliegen
{	
	qer_editorimage textures/fid_china/fliegen.tga
      surfaceparm trans	
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	
	qer_trans .5
	//tessSize 4
	deformVertexes autosprite
	deformVertexes move 10 10.3 0  sin 0 5 0 0.1
          
	cull none
        //nopicmip
        
      
       
	{
		map textures/fid_china/fliegen.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll -.2 -0.1
                tcMod turb .2 .17 0 -.3
                //rgbGen wave triangle 0.5 0.3 0 .9
                blendFunc blend
        }
        {
		map textures/fid_china/fliegen.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll .2 -0.1
                tcMod turb .2 .17 0 -.3
                //rgbGen wave triangle 0.5 0.3 0 .7
                blendFunc blend
        }
         {
		map textures/fid_china/fliegen.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll .2 0.1
                tcMod turb .2 .17 0 -.2
                //rgbGen wave triangle 0.5 0.3 0 .7
                blendFunc blend
        }
         {
		map textures/fid_china/fliegen.tga
                tcMod Stretch sin 1 0.2 0.2 .01
                tcMod Scroll -.2 0.14
                tcMod turb .12 .2 0 -.16
                //rgbGen wave triangle 0.5 0.3 0 .7
                blendFunc blend
        }

}

           







/////////////////////////////////////////////////////
// ALPHA KANAL
//
//

// FlipFlops
//
textures/fid_china/fid_flipflops
{
         qer_editorimage textures/fid_china/fid_bambus_flipflop.tga
	   surfaceparm trans 
         surfaceparm alphashadow
         cull none
         nopicmip
         
{
         map textures/fid_china/fid_bambus_flipflop.tga
         blendFunc GL_ONE GL_ZERO
         alphaFunc GE128 
         depthWrite
         rgbGen identity
      }
{
         map $lightmap
         rgbGen identity
         blendFunc GL_DST_COLOR GL_ZERO
         depthFunc equal
      }
}



//Holzkletterding
//

textures/fid_china/fid_latace_kletter
{
    qer_editorimage textures/fid_china/fid_latace.tga
	surfaceparm woodsteps
    surfaceparm nomarks
    nomipmaps
    nopicmip
    cull disable
//  surfaceparm alphashadow
    {
        map textures/fid_china/fid_latace.tga
       //alphaFunc GE128
	blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        depthWrite
        rgbGen vertex

    }
}

 









/////////////////////////////////////////////////////
// CUSTOM MODELLE
//
//
//



//Buddha, thx for the great models
//
models\mapobjects\buddha\buddha_g
{

	{
		map models\mapobjects\buddha\buddha_g.tga
		rgbGen identityLighting
	}
	{
		map models\mapobjects\buddha\enviromap.tga
		blendfunc filter
		rgbGen identityLighting
		tcGen environment 
	}

	{
		map $lightmap 
		blendfunc filter
		rgbGen identity
	}
}

models\mapobjects\buddha\buddha_j
{
	{
		map models\mapobjects\buddha\buddha_j.tga
		rgbGen identityLighting
	}
	{
		map models\mapobjects\buddha\enviromap2.tga
		blendfunc filter
		rgbGen identityLighting
		tcGen environment 
	}

	{
		map $lightmap 
		blendfunc filter
		rgbGen identity
	}
}

models\mapobjects\buddha\buddha_m
{
    surfaceparm alphashadow
    	
       {
               map models\mapobjects\buddha\effect.tga
		   blendfunc add
		   tcGen environment 
               tcMod scroll .3 1 
		   tcMod rotate 100
               rgbGen wave sin .5 1 0 .3
       }
	{    
		map models\mapobjects\buddha\buddha_m.tga
		blendfunc blend
		rgbGen wave sin 0 1 0 .3
		alphaGen wave sin 0 1 0 .3            
	}
}

models\mapobjects\buddha\buddha_f
{
        deformVertexes wave 100 sin 0 .7 0 .2
	//cull disable
        {
                map models\mapobjects\buddha\buddha_d.tga
                rgbGen vertex
        }
	{
                map models\mapobjects\buddha\buddha_f.tga
		blendFunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen	wave sin -.5 1.5 1 .1
                rgbGen vertex
	}	
	{
		map $lightmap 
		rgbGen identity
		blendfunc filter

	}
}







//////////////////////////////////////////
// normalmaps
//
//
// gute ergebnisse mit:
// -light -fast -samples 2 -thresh 0.25 -external  SOWIE hohem lightmapscale


//Dach
textures/fid_china/fid_roof_bump
{
   qer_editorimage textures/fid_china/fid_roof.jpg

   // PHONG
   q3map_nonplanar
   q3map_shadeangle 60
   // PHONG ENDE

   q3map_normalimage textures/fid_china/fid_roof_bump.tga
   {
      map $lightmap
      rgbGen identity
   }
   {
      map textures/fid_china/fid_roof.jpg
      blendFunc GL_DST_COLOR GL_ZERO
      rgbgen identity
   }
} 





















