//*******************************************************************************
//******teutoburg.shader for map teutoburg_forest****************************** 
//******Shader made by Teuthis based on Tutorial by Sock*************************
//******Website : http://www.planetquake.com/simland/****************************
//******Thank you very much Sock for the blending Tut and the shader file********
//******file modified by Teuthis************************************************* 
//*******************************************************************************
//

// ======================================================================t
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/teutoburg/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/teutoburg/alpha_025	//25 percent secondary texture
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/teutoburg/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/teutoburg/alpha_075	//75 percent secondary texture
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/teutoburg/alpha_085	//85 percent secondary texture
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/teutoburg/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}



//========================================================
// phong shader for top1
//========================================================
textures/teutoburg/top1
{
	q3map_nonplanar
 	q3map_shadeangle 60
	surfaceparm snowsteps
 	qer_editorimage textures/teutoburg/top1.tga
 	{
 		map $lightmap
 		rgbGen identity
 	}
 	{
 		map textures/teutoburg/top1.tga
 		blendFunc filter
	}
 }


//========================================================
// phong shader for bottom1
//========================================================
textures/teutoburg/bottom1
{
	q3map_nonplanar
 	q3map_shadeangle 60
	surfaceparm snowsteps
 	qer_editorimage textures/teutoburg/bottom1.tga
 	{
 		map $lightmap
 		rgbGen identity
 	}
 	{
 		map textures/teutoburg/bottom1.tga
 		blendFunc filter
	}
 }

// ======================================================================
// shader for vertical blending mud1
// ======================================================================
textures/teutoburg/mud1
{
	qer_editorimage textures/teutoburg/mud1.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/stone/mxrock3h_snow.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending dirt1
// ======================================================================
textures/teutoburg/dirt1
{
	qer_editorimage textures/teutoburg/dirt1.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/snow_sd/bigrock_rounded_faint.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending ivec1
// ======================================================================
textures/teutoburg/ivec1
{
	qer_editorimage textures/teutoburg/ivec1.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/snow_sd/snow_noisy.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending moss1
// ======================================================================
textures/teutoburg/moss1
{
	qer_editorimage textures/teutoburg/moss1.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/snow_sd/bunkerwall_lrg02.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending gravel1
// ======================================================================
textures/teutoburg/gravel1
{
	qer_editorimage textures/teutoburg/gravel1.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/egypt_walls_sd/debri_m05.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending dirt2
// ======================================================================
textures/teutoburg/dirt2
{
	qer_editorimage textures/teutoburg/dirt2.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/concrete/cement.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for snow hill with surfaceparm to go through
// ======================================================================
textures/teutoburg/s_hill
{
	qer_editorimage textures/teutoburg/s_hill.tga
	surfaceparm snowsteps
	surfaceparm landmine
	surfaceparm nonsolid
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/stone/mxrock3h_snow.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for icicles on houses etc.
// ======================================================================

textures/teutoburg/icicles
{
    qer_editorimage textures/teutoburg/icicles.tga
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm nonsolid
    cull disable
    {
        map textures/teutoburg/icicles.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }

}

// ======================================================================
// shader for blocking explosion of bridge when truck is on
// ======================================================================

textures/teutoburg/bridgeblock
{
    qer_editorimage textures/teutoburg/bridgeblock.tga
    surfaceparm noimpact
    surfaceparm trans

    cull disable
    {
        map textures/teutoburg/bridgeblock.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }

}

// ======================================================================
// shader for vertical blending dirt3
// ======================================================================
textures/teutoburg/dirt3
{
	qer_editorimage textures/teutoburg/dirt3.tga
	surfaceparm snowsteps
	surfaceparm landmine
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/teutoburg/ground_stone.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_var01_big.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader texture ground_stone
// ======================================================================

textures/teutoburg/ground_stone
{
	surfaceparm grasssteps
	implicitMap -
}

