// Shaders for ginc's Supply Depot map \o/
// Edited for Supply Depot Winter Edition
// Last Update: 26/06/2013

// *********************************************
// *************** Model Shaders ***************
// *********************************************

// *********************************************
// Retexture of the Blitz
// Only body and windows because arches don't work
// *********************************************
models/supply_we/blitz_sd_arches_s
{
	qer_editorimage models/supply_we/blitz_sd_s2.tga
	cull twosided
	implicitMap models/supply_we/blitz_sd_s2.tga
}

models/supply_we/blitz_sd_body_s
{
	qer_editorimage models/supply_we/blitz_sd_s2.tga
	{
		map models/supply_we/blitz_sd_s2.tga
		rgbGen lightingDiffuse
	}
}

models/supply_we/blitz_sd_windows_s
{
	qer_editorimage models/supply_we/blitz_sd_s2.tga
	{
		map textures/effects/envmap_slate.tga
		rgbGen lightingdiffuse
		tcGen environment
	}
	{
		map models/supply_we/blitz_sd_s2.tga
		blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
		rgbGen lightingDiffuse
	}
}

models/supply_we/leaves_temperate1_snow
{
	noPicMip
	qer_alphafunc greater 0.5
	qer_editorimage models/supply_we/leaves_temperate1_snow.tga
	cull disable
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	implicitMask -
}

models/supply_we/leaves_temperate2_snow
{
	noPicMip
	qer_alphafunc greater 0.5
	qer_editorimage models/supply_we/leaves_temperate2_snow.tga
	cull disable
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	implicitMask -
}

models/supply_we/leaves_temperate3_snow
{
	noPicMip
	qer_alphafunc greater 0.5
	qer_editorimage models/supply_we/leaves_temperate3_snow.tga
	cull disable
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	implicitMask -
}

models/supply_we/srock_clip
{
	qer_editorimage models/mapobjects/rocks_sd/rock_snow_big.jpg
	implicitMap models/mapobjects/rocks_sd/rock_snow_big.jpg
	q3map_clipModel
}


// *********************************************
// **************** Sky Shaders ****************
// *********************************************
textures/supply_we/supply_we_sky
{
	qer_editorimage textures/supply_we/supply_we_sky.jpg
	q3map_skylight 90 3
	q3map_sun 0.55 0.55 0.55 90 220 60
	noCompress
	skyParms - 200 -
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	{
		map textures/supply_we/supply_we_sky.jpg
		//tcMod scale 1 1
		//blendFunc add
		//rgbGen const ( 0.6 0.6 0.6 )
        rgbGen identity
	}
	{
		//clampmap textures/supply_we/supply_we_sky.jpg
		//blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		//tcMod scale 0.956 0.956
		//tcMod transform 1 0 0 1 -1 -1
		//rgbGen const ( 0.6 0.6 0.6 )
        map textures/supply_we/supply_we_sky.jpg
		blendFunc blend
		rgbGen identity
	}
}

// *********************************************
// ************** Terrain Shaders **************
// *********************************************

textures/editor_image/alpha_000
{
	qer_trans 0.95
	qer_editorimage textures/editor_image/alpha_000.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/editor_image/alpha_100
{
	qer_trans 0.95
	qer_editorimage textures/editor_image/alpha_100.tga
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/supply_we/terrain_base
{
    q3map_nonPlanar
	q3map_shadeAngle 60
	q3map_lightmapAxis z
	q3map_tcMod rotate 37
	// Removes edges on some shadows, but bug patches and some other shadows applies on different planes...
	// Requires q3map_nonPlanar to fix
	q3map_lightmapMergable
	q3map_lightmapSize 512 512
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
}

textures/supply_we/snow_floor
{
	qer_editorimage textures/editor_image/terrain0.tga
	q3map_baseshader textures/supply_we/terrain_base
	surfaceparm landmine
	surfaceparm snowsteps
	{
		map textures/snow_sd/snow_var01_big.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbGen identity
		detail
	}
}

textures/supply_we/snow_floor2
{
	qer_editorimage textures/editor_image/terrain2.tga
	q3map_baseshader textures/supply_we/terrain_base
	surfaceparm landmine
	surfaceparm snowsteps
	{
		map textures/stone/mxsnow2.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbGen identity
		detail
	}
}

textures/supply_we/terrain0to1
{
	qer_editorimage textures/editor_image/terrain0to1.tga
	q3map_baseshader textures/supply_we/terrain_base
	surfaceparm gravelsteps
	{
		map textures/snow_sd/snow_var01_big.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/dirt3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbGen identity
		detail
	}
}

textures/supply_we/terrain0to3
{
	qer_editorimage textures/editor_image/terrain0to3.tga
	q3map_baseshader textures/supply_we/terrain_base
	surfaceparm gravelsteps
	{
		map textures/snow_sd/snow_var01_big.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/road_bigpuddle.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbGen identity
		detail
	}
}

textures/supply_we/terrain1to2
{
	qer_editorimage textures/editor_image/terrain1to2.tga
	q3map_baseshader textures/supply_we/terrain_base
	surfaceparm gravelsteps
	{
		map textures/stone/mxsnow2.tga
		rgbGen identity
	}
	{
		map textures/temperate_sd/dirt3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/snowdetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbGen identity
		detail
	}
}


// *********************************************
// ************** Texture Shaders **************
// *********************************************

textures/supply_we/bars_noclip_snow
{
	qer_editorimage textures/snow/s_bars_m01.tga
	cull disable
	noMipMaps
	noPicMip
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/snow/s_bars_m01.tga
}

textures/supply_we/box_m04a_sd_s
{
	qer_editorimage textures/supply_we/box_m04a_sd_s.jpg
	surfaceparm woodsteps
	implicitMap -
}

textures/supply_we/cathedrale_c13_s
{
	qer_editorimage textures/supply_we/cathedrale_c13_s.jpg
	implicitMap -
}

textures/supply_we/concrete_c05_snow
{
	qer_editorimage textures/miltary_wall/concrete_c05.jpg
	{
		map textures/miltary_wall/concrete_c05.jpg
		rgbGen identity
	}
	{
		map textures/snow/s_cathedrale_c24b.jpg
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/supply_we/dirt
{
	qer_editorimage textures/editor_image/terrain1.tga
	q3map_nonPlanar
	q3map_shadeAngle 60
	q3map_tcMod rotate 37
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	surfaceparm gravelsteps
	{
		map textures/temperate_sd/dirt3.tga
		rgbGen identity
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/detail_sd/sanddetail.tga
		blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbGen identity
		detail
	}
}

textures/supply_we/rock_snow
{
	qer_editorimage textures/editor_image/terrain5.tga
	q3map_nonPlanar
	q3map_shadeAngle 60
	q3map_tcMod rotate 37
	{
		map textures/stone/mxrock3h_snow.tga
		rgbGen identity
		tcMod scale 0.125 0.125
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/supply_we/rock_temperate
{
	qer_editorimage textures/editor_image/terrain6.tga
	q3map_nonPlanar
	q3map_shadeAngle 60
	q3map_tcMod rotate 37
	{
		map textures/temperate_sd/rock_ugly_brown.tga
		rgbGen identity
		tcMod scale 0.125 0.125
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/supply_we/s_town_c91_decal
{
	polygonOffset
	surfaceparm pointlight
	implicitBlend -
}

textures/supply_we/wood_m02_s
{
	surfaceparm woodsteps
	implicitMap -
}

textures/supply_we/wood_m02_s_to_wood_m02
{
	qer_editorimage textures/editor_image/terrain4.tga
	q3map_tcGen ivector ( 256 0 0 ) ( 0 128 0 )
	surfaceparm woodsteps
	{
		map textures/supply_we/wood_m02_s.jpg
		rgbGen identity
	}
	{
		map textures/wood/wood_m02.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/supply_we/xfloor_c05_snow
{
	qer_editorimage textures/snow_sd/concretec05_snow.tga
	{
		map textures/xlab_floor/xfloor_c05.jpg
		rgbGen identity
	}
	{
		map textures/snow/s_cathedrale_c24b.jpg
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		alphaGen vertex
	}
	{
		lightmap $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// *********************************************
// ************* Unaltered Shaders *************
// *********************************************

models/mapobjects/rocks_sd/temprock_clip
{
	qer_editorimage models/mapobjects/rocks_sd/rock_temperate_big.tga
	implicitMap models/mapobjects/rocks_sd/rock_temperate_big.tga
	q3map_clipModel
}

textures/ginc/truss_noclip
{
	qer_editorimage textures/alpha/truss_m06
	cull disable
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	noPicMip
	implicitMask textures/alpha/truss_m06
}