// ======================================================================
// levelshots
// ======================================================================
levelshots/mountainpass_finale_cc_automap
{
	nopicmip
	nocompress
	{
		clampmap levelshots/mountainpass_finale_cc.tga
		depthFunc equal
		rgbGen identity
	}
}

levelshots/mountainpass_finale_cc_trans
{
	nopicmip
	nocompress
	{
		clampmap levelshots/mountainpass_finale_cc.tga
		blendfunc blend
		rgbGen identity
		alphaGen vertex
	}
}

// ======================================================================
// tree_pine_snow
// ======================================================================
models/mapobjects/vehicles/truckside4l
{
	cull twosided
	{
        map models/mapobjects/vehicles/truckside4l.tga
		alphaFunc GE128
		depthWrite
//		rgbGen vertex
//		rgbGen lightingdiffuse
		rgbGen identity
	}
}

models/mapobjects/vehicles/truck_shadow
{
	{
	map models/mapobjects/vehicles/truck_shadow.tga
	blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//	blendFunc blend
	rgbGen vertex
//	rgbGen identity
	}
 }

// ======================================================================
// tree_pine_snow
// ======================================================================
//Credits BY team mirage
models/mapobjects/tree_pine_snow/branches
{
    qer_trans 0.70
	qer_alphafunc greater 0.65
	q3map_alphaGen const 0.65
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	cull disable
	nopicmip
	{
        map models/mapobjects/tree_pine_snow/skin.tga
		alphaFunc GE128
		depthWrite
//		rgbgen lightingDiffuse
		rgbgen vertex
	}
}


// ======================================================================
// XMAS TREE
// ======================================================================
models/conife_tree/branch
{
	qer_alphafunc greater 0.65
	q3map_alphaGen const 0.65
	surfaceparm alphashadow
	surfaceparm trans
	surfaceparm nomarks
	cull disable
	nopicmip
	{
        map models/conife_tree/branch.tga
		alphaFunc GE128
		depthWrite
		rgbgen vertex
	}
}

// ======================================================================
// snow_night_peaks with jcook_nlights 
// ======================================================================
textures/mountainpass_finale_skybox/snow_night_peaks2
{
	qer_editorimage textures/mountainpass_finale_skybox/snow_night_peaks_editor.tga
	skyParms textures/mountainpass_finale_skybox/snow_night_peaks - -
	q3map_noFog
    surfaceparm sky               //flags compiler that this is sky
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	nopicmip
	
        q3map_sunExt 0.68 0.68 0.90 20 250 50 0 32 // R G B Intensity Angle Pitch
        q3map_lightmapFilterRadius 0 16
        q3map_skylight 0 6                    //amount iterations
	{
		map textures/mountainpass_finale_skybox/clouds.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
	{
		map textures/mountainpass_finale_skybox/jcook_nlights.tga
		blendfunc add
		tcMod scale 2 1
		tcMod scroll .01 .01
	}
}
// ======================================================================
// BURN WOOD
// ======================================================================
textures/mountainpass_finale_wood/burning_wood
{
	qer_editorimage textures/mountainpass_finale_wood/burn_wood_2.tga
	q3map_surfacelight 200
	surfaceparm nomarks
	{
		map $lightmap 
		rgbGen identity
	}
	{
		map textures/mountainpass_finale_wood/burn_wood_2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mountainpass_finale_wood/burn_wood_blend_2.tga
		rgbGen wave sin 0.3 0.3 0 0.25
		blendfunc GL_ONE GL_ONE
	}
}

// ======================================================================
// LIGHTS
// ======================================================================
textures/mountainpass_finale_lights/xmas_lights_string2
{
	qer_editorimage textures/mountainpass_finale_lights/xmas_lights_string2.tga
	q3map_surfacelight 50
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nolightmap
	surfaceparm nomarks
	cull none
	{
		map textures/mountainpass_finale_lights/xmas_lights_string2.tga
 		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GT0
		rgbGen identity
	}
}

textures/mountainpass_finale_lights/xmas_blue_light
{
	qer_editorimage textures/mountainpass_finale_lights/xmas_blue_light.tga
	q3map_surfacelight 10
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nolightmap
	surfaceparm nomarks
	cull none
	deformVertexes autosprite2
	{
		map textures/mountainpass_finale_lights/xmas_blue_light.tga
		rgbGen wave sin 0 1 0.7 0.3
		blendfunc add
		rgbGen identity
		tcMod stretch sin 1.0 0.1 0.5 0.5
	}
}
textures/mountainpass_finale_lights/xmas_yellow_light
{
	qer_editorimage textures/mountainpass_finale_lights/xmas_yellow_light.tga
    q3map_surfacelight 10
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nolightmap
	surfaceparm nomarks
	cull none
	deformVertexes autosprite2
	{
		map textures/mountainpass_finale_lights/xmas_yellow_light.tga
		rgbGen wave sin 0 1 0.7 0.3
		blendfunc add
		rgbGen identity
		tcMod stretch sin 1.0 0.1 0.5 0.5
	}
}
textures/mountainpass_finale_lights/xmas_red_light
{
	qer_editorimage textures/mountainpass_finale_lights/xmas_red_light.tga
    q3map_surfacelight 10
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nolightmap
	surfaceparm nomarks
	cull none
	deformVertexes autosprite2
	{
		map textures/mountainpass_finale_lights/xmas_red_light.tga
		rgbGen wave sin 0 1 0.7 0.3
		blendfunc add
		rgbGen identity
		tcMod stretch sin 1.0 0.1 0.5 0.5
	}
}
textures/mountainpass_finale_lights/xmas_green_light
{
	qer_editorimage textures/mountainpass_finale_lights/xmas_green_light.tga
    q3map_surfacelight 10
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nolightmap
	surfaceparm nomarks
	cull none
	deformVertexes autosprite2
	{
		map textures/mountainpass_finale_lights/xmas_green_light.tga
		rgbGen wave sin 0 1 0.7 0.3
		blendfunc add
		rgbGen identity
		tcMod stretch sin 1.0 0.1 0.5 0.5
	}
}
textures/mountainpass_finale_lights/light_m21_5000
{
	qer_editorimage textures/mountainpass_finale_lights/light_m21.tga
	q3map_surfacelight 5000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mountainpass_finale_lights/light_m21.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mountainpass_finale_lights/light_m21.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/mountainpass_finale_lights/light_m16_small_5000
{
	qer_editorimage textures/mountainpass_finale_lights/light_m16.tga
	q3map_surfacelight 5000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/mountainpass_finale_lights/light_m16.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/mountainpass_finale_lights/light_m16.blend.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/mountainpass_finale_lights/flare2
{
    qer_editorimage textures/mountainpass_finale_lights/flare2.tga
    surfaceparm trans
    surfaceparm nolightmap
    deformVertexes autoSprite2
    cull disable
	{
		map textures/mountainpass_finale_lights/flare2.tga
		blendFunc Add
		rgbGen identity
	}
}
textures/mountainpass_finale_lights/wilsflame1
{
	qer_editorimage textures/mountainpass_finale_lights/flame1.tga
	q3map_surfacelight 1482
	cull none
	nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	surfaceparm trans
	{
		animMap 10 textures/mountainpass_finale_lights/flame1.tga textures/mountainpass_finale_lights/flame2.tga textures/mountainpass_finale_lights/flame3.tga textures/mountainpass_finale_lights/flame4.tga textures/mountainpass_finale_lights/flame5.tga textures/mountainpass_finale_lights/flame6.tga textures/mountainpass_finale_lights/flame7.tga textures/mountainpass_finale_lights/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
	}
	{
		animMap 10 textures/mountainpass_finale_lights/flame2.tga textures/mountainpass_finale_lights/flame3.tga textures/mountainpass_finale_lights/flame4.tga textures/mountainpass_finale_lights/flame5.tga textures/mountainpass_finale_lights/flame6.tga textures/mountainpass_finale_lights/flame7.tga textures/mountainpass_finale_lights/flame8.tga textures/mountainpass_finale_lights/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}
	{
		map textures/mountainpass_finale_lights/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6
	}
}

// ======================================================================
// MISC
// ======================================================================
textures/mountainpass_finale_misc/toy_frame
{
    qer_editorimage textures/mountainpass_finale_misc/toy_frame.tga
    qer_trans 0.70
    surfaceparm alphashadow
    cull none
    {
		map textures/mountainpass_finale_misc/tinfx.tga
        blendFunc GL_ONE GL_ONE
        tcgen environment
        rgbGen identity
	}
	{
		map textures/mountainpass_finale_misc/toy_frame.tga
        alphaFunc GE128
        depthWrite
	}
    {
		map $lightmap
		rgbGen identity
		blendFunc filter
	}
}

textures/mountainpass_finale_misc/xmas_bulb
{
	qer_editor_image textures/mountainpass_finale_misc/xmas_bulb.tga
	qer_trans 0.70	
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm nolightmap
	surfaceparm nomarks
	deformVertexes autosprite
	nopicmip
	cull disable
	{
		map textures/mountainpass_finale_misc/xmas_bulb.tga
		alphaFunc GE128
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

textures/mountainpass_finale_misc/xmas_wrapping_bow
{
	qer_editorimage textures/mountainpass_finale_misc/xmas_wrapping_bow.tga
    surfaceparm nonsolid
	nopicmip
	cull disable
	polygonOffset
	sort decal
	{
		map textures/mountainpass_finale_misc/xmas_wrapping_bow.tga
		blendfunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendfunc filter
		depthFunc equal
	}
}

textures/mountainpass_finale_misc/ice_cicles_cull_disable
{
	qer_editorimage textures/mountainpass_finale_misc/ice_cicles.tga
	qer_trans 0.70
	surfaceparm trans
	surfaceparm nomarks
	nopicmip
	cull disable
	{
		map textures/mountainpass_finale_misc/ice_cicles.tga
		blendfunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendfunc filter
		depthFunc equal
	}
}
textures/mountainpass_finale_misc/cable_trans_5
{
	qer_editorimage textures/mountainpass_finale_misc/cable_trans_5.tga
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	surfaceparm nonsolid
	cull disable
	nopicmip
	{
		map textures/mountainpass_finale_misc/cable_trans_5.tga
		alphaFunc GE128
		depthWrite
		rgbGen vertex
	}
}
// ======================================================================
// SKELET
// ======================================================================
models/mapobjects/skeleton_sit_rail/skeleton
{
    cull disable
    surfaceparm alphashadow
    {
    	map models/mapobjects/skeleton_sit_rail/skeleton.tga
    	alphaFunc GE128
		depthWrite
		rgbGen vertex
    }
}
// ======================================================================
// TERRAIN
// ======================================================================
textures/common/terrain_0
{
	qer_editorimage textures/common/terrain.tga
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 ) // ( X Y Z ). The axis with 0 in both groups = projection axis. values are power of 2 <128<256<512<1024          
	q3map_lightmapsamplesize 16 // default lightmap sample size is 16,smaller numbers increases lightmap resolution.values are power of 2 <8<16<32<64
	q3map_lightmapaxis z  // Project lightmap on z axis (up/down)
	q3map_nonplanar   // lets the compiler know that its OK to merge triangles that don't lie in the same plane
	q3map_shadeAngle 120 // specifies the triangle edge angle at which the light will be diffused, The larger the specified value the more smooth all the triangles will appear as it affects more edges,Typical values are usually in the 120-179 range
	q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams)
	surfaceparm nomarks
	surfaceparm snowsteps
	surfaceparm landmine
	{
		map textures/mountainpass_finale_terrain/snow.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		tcGen lightmap
	}
}

textures/common/terrain_1
{
	qer_editorimage textures/common/terrain.tga
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 ) // ( X Y Z ). The axis with 0 in both groups = projection axis. values are power of 2 <128<256<512<1024          
	q3map_lightmapsamplesize 16 // default lightmap sample size is 16,smaller numbers increases lightmap resolution.values are power of 2 <8<16<32<64
	q3map_lightmapaxis z  // Project lightmap on z axis (up/down)
	q3map_nonplanar   // lets the compiler know that its OK to merge triangles that don't lie in the same plane
	q3map_shadeAngle 120 // specifies the triangle edge angle at which the light will be diffused, The larger the specified value the more smooth all the triangles will appear as it affects more edges,Typical values are usually in the 120-179 range
	q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams)
	surfaceparm nomarks
	{
		map textures/mountainpass_finale_terrain/rocksnow.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		tcGen lightmap
	}
}

textures/common/terrain_2
{
	qer_editorimage textures/common/terrain.tga
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 ) // ( X Y Z ). The axis with 0 in both groups = projection axis. values are power of 2 <128<256<512<1024          
	q3map_lightmapsamplesize 16 // default lightmap sample size is 16,smaller numbers increases lightmap resolution.values are power of 2 <8<16<32<64
	q3map_lightmapaxis z  // Project lightmap on z axis (up/down)
	q3map_nonplanar   // lets the compiler know that its OK to merge triangles that don't lie in the same plane
	q3map_shadeAngle 120 // specifies the triangle edge angle at which the light will be diffused, The larger the specified value the more smooth all the triangles will appear as it affects more edges,Typical values are usually in the 120-179 range
	q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams)
	surfaceparm nomarks
	surfaceparm snowsteps
	surfaceparm landmine
	{
		map textures/mountainpass_finale_terrain/snowgrass.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		tcGen lightmap
	}
}

textures/common/terrain_0to1
{
	qer_editorimage textures/common/terrain.tga
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 ) // ( X Y Z ). The axis with 0 in both groups = projection axis. values are power of 2 <128<256<512<1024          
	q3map_lightmapsamplesize 16 // default lightmap sample size is 16,smaller numbers increases lightmap resolution.values are power of 2 <8<16<32<64
	q3map_lightmapaxis z  // Project lightmap on z axis (up/down)
	q3map_nonplanar   // lets the compiler know that its OK to merge triangles that don't lie in the same plane
	q3map_shadeAngle 120 // specifies the triangle edge angle at which the light will be diffused, The larger the specified value the more smooth all the triangles will appear as it affects more edges,Typical values are usually in the 120-179 range
	q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams)
	surfaceparm nomarks
	{
	    // Primary texture blend
		map textures/mountainpass_finale_terrain/snow.tga
		rgbGen identity
	}
	{
		// Secondary texture blend
		map textures/mountainpass_finale_terrain/rocksnow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	    rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		tcGen lightmap
	}
}

textures/common/terrain_0to2
{
	qer_editorimage textures/common/terrain.tga
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 ) // ( X Y Z ). The axis with 0 in both groups = projection axis. values are power of 2 <128<256<512<1024          
	q3map_lightmapsamplesize 16 // default lightmap sample size is 16,smaller numbers increases lightmap resolution.values are power of 2 <8<16<32<64
	q3map_lightmapaxis z  // Project lightmap on z axis (up/down)
	q3map_nonplanar   // lets the compiler know that its OK to merge triangles that don't lie in the same plane
	q3map_shadeAngle 120 // specifies the triangle edge angle at which the light will be diffused, The larger the specified value the more smooth all the triangles will appear as it affects more edges,Typical values are usually in the 120-179 range
	q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams)
	surfaceparm nomarks
	{
	    // Primary texture blend
		map textures/mountainpass_finale_terrain/snow.tga
		rgbGen identity
	}
	{
		// Secondary texture blend
		map textures/mountainpass_finale_terrain/snowgrass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	    rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		tcGen lightmap
	}
}

textures/common/terrain_1to2
{
	qer_editorimage textures/common/terrain.tga
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 ) // ( X Y Z ). The axis with 0 in both groups = projection axis. values are power of 2 <128<256<512<1024          
	q3map_lightmapsamplesize 16 // default lightmap sample size is 16,smaller numbers increases lightmap resolution.values are power of 2 <8<16<32<64
	q3map_lightmapaxis z  // Project lightmap on z axis (up/down)
	q3map_nonplanar   // lets the compiler know that its OK to merge triangles that don't lie in the same plane
	q3map_shadeAngle 120 // specifies the triangle edge angle at which the light will be diffused, The larger the specified value the more smooth all the triangles will appear as it affects more edges,Typical values are usually in the 120-179 range
	q3map_lightmapmergable // Merges all terrain into one seamless lightmap (no seams)
	surfaceparm nomarks
	{
	    // Primary texture blend
		map textures/mountainpass_finale_terrain/rocksnow.tga
		rgbGen identity
	}
	{
		// Secondary texture blend
		map textures/mountainpass_finale_terrain/snowgrass.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	    rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		tcGen lightmap
	}
}

