//**********************************************************************//
//
//	Dini_terrain.shader for Q3 by Sock
//	Website : http://www.planetquake.com/simland/
//
//**********************************************************************//
//

textures/Dini_terrain/blacksky	// Used for testing boxmaps
{
	qer_editorimage textures/Dini_terrain/blacksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	{
		map textures/Dini_terrain/blacksky.tga
	}
}

// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/Dini_terrain/test
{
        qer_editorimage textures/Dini_terrain/test.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/Dini_terrain/test.tga	// Primary
		rgbGen identity
	}
	{
		map textures/Dini_terrain/test2.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/Dini_terrain/grassishgood
{
    qer_editorimage textures/Dini_terrain/ter_moss1.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/Dini_terrain/ter_moss1_3.tga	// Primary
		rgbGen identity
	}
	{
		map textures/Dini_terrain/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/Dini_terrain/ter_dirtmud
{
        qer_editorimage textures/Dini_terrain/ter_dirtmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/Dini_terrain/ter_dirt1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/Dini_terrain/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/Dini_terrain/ter_mossmud
{
        qer_editorimage textures/Dini_terrain/ter_mossmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/Dini_terrain/ter_moss1.tga	// Primary
		rgbGen identity
	}
	{
		map textures/Dini_terrain/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/Dini_terrain/ter_rockmud
{
        qer_editorimage textures/Dini_terrain/ter_rockmud.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	
	{
		map textures/Dini_terrain/ter_rock3.tga	// Primary
		rgbGen identity
	}
	{
		map textures/Dini_terrain/ter_mud1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


textures/Dini_terrain/iceterrain
{
    qer_editorimage textures/snow_sd/icelake2.tga
	
	q3map_nonplanar
	q3map_shadeangle 120
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	surfaceparm slick
	{
        map textures/snow_sd/icelake2.tga	
	    rgbGen identity
	}
	{
		map textures/Dini_terrain/icelake2_white.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
   	    map textures/Dini_div1/base6.jpg
   		blendFunc GL_ONE GL_ONE_MINUS_SRC_COLOR
    	rgbGen identity //vertex
    	tcGen environment
    }
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}







// ======================================================================
// Hong Phonged textures
// ======================================================================
textures/Dini_terrain/ter_rock2
{
	q3map_nonplanar
	q3map_shadeangle 120
        qer_editorimage textures/Dini_terrain/ter_rock2.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/Dini_terrain/ter_rock2.tga
		blendFunc filter
	}
}

// ======================================================================
// Alpha blending without dotProduct2 and ivector
// ======================================================================
textures/Dini_terrain/bld_rock2moss1		// Normal texture blending
{
        qer_editorimage textures/Dini_terrain/bld_rock2moss1.tga
	
	q3map_nonplanar
	q3map_shadeAngle 120
	
	{
		map textures/Dini_terrain/ter_rock2.tga	// Primary
		rgbGen identity
	}
	{
		map textures/Dini_terrain/ter_moss1.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/Dini_terrain/dcl_moss1		// Decal blending
{
        qer_editorimage textures/Dini_terrain/ter_moss1.tga
	q3map_nonplanar 
	q3map_shadeangle 120 
	polygonoffset
	{
		map textures/Dini_terrain/ter_moss1.tga
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
		depthFunc equal
	}
}

textures/Dini_terrain/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	qer_trans 0.75
}

textures/Dini_terrain/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/Dini_terrain/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/Dini_terrain/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/Dini_terrain/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/Dini_terrain/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}


textures/Dini_terrain/test_0
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_moss1.tga
		rgbGen vertex
		tcmod scale 0.500 0.500
	}
}

textures/Dini_terrain/test_1
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_dirt1.tga
		rgbGen vertex
		tcmod scale 0.500 0.500
	}
}

textures/Dini_terrain/test_2
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_mud1.tga
		rgbGen vertex
		tcmod scale 0.500 0.500
	}
}

textures/Dini_terrain/test_0to1
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_moss1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500 0.500
	}
	{
		map textures/Dini_terrain/ter_dirt1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500 0.500
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/Dini_terrain/test_0to2
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_moss1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500 0.500
	}
	{
		map textures/Dini_terrain/ter_mud1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500 0.500
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/Dini_terrain/test_1to2
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_dirt1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500 0.500
	}
	{
		map textures/Dini_terrain/ter_mud1.tga
		rgbGen vertex
		alphaGen vertex
		tcmod scale 0.500 0.500
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

textures/Dini_terrain/test.vertex
{
	surfaceparm nolightmap
	q3map_novertexshadows
	q3map_forcesunlight
	{
		map textures/Dini_terrain/ter_moss1.tga
		rgbGen vertex
		tcmod scale 0.500 0.500
	}
}

