//**********************************************************************//
//
//	thunder_alps.shader for map Alps_Trail. Shader based on Tutorial by Sock
//	Website : http://www.planetquake.com/simland/
//	Thank you very much Sock for the blending Tut and the shader file.
//	file modified by Teuthis. 
//**********************************************************************//

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================

// ======================================================================
// shader for alpha Poles
// ======================================================================

textures/thunder_alps/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
	
}

textures/thunder_alps/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/thunder_alps/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/thunder_alps/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/thunder_alps/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/thunder_alps/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

// ======================================================================
// shader for vertical blending - blend_1
// ======================================================================
textures/thunder_alps/blend_1
{
    surfaceparm landmine 
    surfaceparm snowsteps
	qer_editorimage textures/thunder_alps/blend_1.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/snow_sd/snow_noisy.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/twt_snow/snow_track.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending - blend_2
// ======================================================================
textures/thunder_alps/blend_2
{
    surfaceparm landmine 
    surfaceparm snowsteps
	qer_editorimage textures/thunder_alps/blend_2.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/snow_sd/snow_noisy.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/concrete/cement.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending - blend_3
// ======================================================================
textures/thunder_alps/blend_3
{
    surfaceparm landmine 
    surfaceparm snowsteps
	qer_editorimage textures/thunder_alps/blend_3.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	
	{
		// Primary
		map textures/thunder_alps/clay_snow1.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending - blend_4
// ======================================================================
textures/thunder_alps/blend_4
{
	qer_editorimage textures/thunder_alps/blend_4.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	surfaceparm landmine 
    surfaceparm snowsteps
	
	{
		// Primary
		map textures/twt_snow/spiralsnow.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ======================================================================
// shader for vertical blending - blend_5
// ======================================================================
textures/thunder_alps/blend_5
{
	qer_editorimage textures/thunder_alps/blend_5.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	surfaceparm landmine 
    surfaceparm snowsteps
	
	{
		// Primary
		map textures/twt_snow/spiralsnow.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/twt_snow/Glacier.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}


// ======================================================================
// shader for vertical blending - blend_6
// ======================================================================
textures/thunder_alps/blend_6
{
    surfaceparm landmine 
    surfaceparm snowsteps
	qer_editorimage textures/thunder_alps/blend_6.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/thunder_alps/clay_snow1.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow/s_cathedrale_c06.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}
// ======================================================================
// shader for vertical blending - blend_23
// ======================================================================
textures/thunder_alps/blend_23
{
	qer_editorimage textures/thunder_alps/blend_23.tga
	surfaceparm landmine 
    surfaceparm snowsteps
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/snow_sd/bigrock_rounded_faint.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending - blend_24
// ======================================================================
textures/thunder_alps/blend_24
{
	qer_editorimage textures/thunder_alps/blend_24.tga
	surfaceparm landmine 
    surfaceparm snowsteps
	q3map_nonplanar
	q3map_shadeAngle 60
	
	{
		// Primary
		map textures/twt_snow/rock_snow2.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// shader for vertical blending - blend_25
// ======================================================================
textures/thunder_alps/blend_25
{
	qer_editorimage textures/thunder_alps/blend_25.tga
	
	q3map_nonplanar
	q3map_shadeAngle 60
	surfaceparm landmine 
    surfaceparm snowsteps
	
	{
		// Primary
		map textures/twt_snow/deepfreeze.tga
		rgbGen identity
	}
	{
		// Secondary
		map textures/snow_sd/snow_noisy.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

//========================================================
// phong shader fors s_dirt_m03i_2
//========================================================
textures/snow/s_dirt_m03i_2_p.tga
{
    surfaceparm landmine 
    surfaceparm snowsteps
	q3map_nonplanar
 	q3map_shadeangle 60
 	qer_editorimage textures/snow/s_dirt_m03i_2_p.tga
 	{
 		map $lightmap
 		rgbGen identity
 	}
 	{
 		map textures/snow/s_dirt_m03i_2_p.tga
 		blendFunc filter
	}
 }

//========================================================
// phong shader fors snow_noisy
//========================================================
textures/snow_sd/snow_noisy_p.tga
{
    surfaceparm landmine 
    surfaceparm snowsteps
	q3map_nonplanar
 	q3map_shadeangle 60
 	qer_editorimage textures/snow_sd/snow_noisy_p.tga
 	{
 		map $lightmap
 		rgbGen identity
 	}
 	{
 		map textures/snow_sd/snow_noisy_p.tga
 		blendFunc filter
	}
 }