// *********************************************
// ******* 1944 Huertgen Forest Shaders ********
// *************** X-Mas Edition ***************
// *********** By Kommando & Mateos ************
// ********* Last Update: 28 Dec. 2014 *********
// *********************************************

// *********************************************
// ************ Custom Icon Shaders ************
// *********************************************

gfx/1944_huertgen_xmas/cm_aagun
{
    noMipMaps
    noCompress
    {
        map gfx/1944_huertgen_xmas/cm_aagun.tga
        depthFunc equal
        blendFunc blend
        rgbGen vertex
        alphaGen vertex
    }
}

gfx/1944_huertgen_xmas/cm_axisammoroom
{
    noMipMaps
    noCompress
    {
        map gfx/1944_huertgen_xmas/cm_axisammoroom.tga
        depthFunc equal
        blendFunc blend
        rgbGen vertex
        alphaGen vertex
    }
}

gfx/1944_huertgen_xmas/cm_axispath
{
    noMipMaps
    noCompress
    {
        map gfx/1944_huertgen_xmas/cm_axispath.tga
        depthFunc equal
        blendFunc blend
        rgbGen vertex
        alphaGen vertex
    }
}

gfx/1944_huertgen_xmas/cm_blast
{
    noMipMaps
    noCompress
    {
        map gfx/1944_huertgen_xmas/cm_blast.tga
        depthFunc equal
        blendFunc blend
        rgbGen vertex
        alphaGen vertex
    }
}

gfx/1944_huertgen_xmas/cm_truckyardgate
{
    noMipMaps
    noCompress
    {
        map gfx/1944_huertgen_xmas/cm_truckyardgate.tga
        depthFunc equal
        blendFunc blend
        rgbGen vertex
        alphaGen vertex
    }
}


// *********************************************
// ************** Terrain Shaders **************
// *********************************************

textures/1944_huertgen_xmas/alpha_000
{
    qer_trans 0.95
    qer_editorimage textures/common/alpha_0.tga
    q3map_alphaMod volume
    q3map_alphaMod set 0.0
    surfaceparm nodraw
    surfaceparm nonsolid
    surfaceparm trans
}

textures/1944_huertgen_xmas/alpha_100
{
    qer_trans 0.95
    qer_editorimage textures/common/alpha_100.tga
    q3map_alphaMod volume
    q3map_alphaMod set 1.0
    surfaceparm nodraw
    surfaceparm nonsolid
    surfaceparm trans
}

textures/1944_huertgen_xmas/terrain_base
{
    q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
    q3map_lightmapAxis z
    q3map_lightmapMergable
    q3map_lightmapSampleSize 32
    q3map_lightmapSize 512 512
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
    q3map_tcMod rotate 37
}

textures/1944_huertgen_xmas/forest_floor
{
    qer_editorimage textures/editor_image/terrain2.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    surfaceparm landmine
    surfaceparm snowsteps
    {
        map textures/snow_sd/s_grass_ml03b_big.jpg
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/bigrock_rounded_faint
{
    qer_editorimage textures/editor_image/terrain0.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    {
        map textures/snow_sd/bigrock_rounded_faint.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/snow_dirt
{
    qer_editorimage textures/editor_image/terrain1.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    surfaceparm landmine
    surfaceparm snowsteps
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/dirt
{
    qer_editorimage textures/editor_image/terrain4.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    surfaceparm gravelsteps
    {
        map textures/temperate_sd/dirt_m03icmp_brown.jpg
        rgbGen identity
        tcMod scale 2 2
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/dirt_blending
{
    qer_editorimage textures/editor_image/terrain1to4.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    surfaceparm gravelsteps
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map textures/temperate_sd/dirt_m03icmp_brown.jpg
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        alphaGen vertex
        rgbGen identity
        tcMod scale 2 2
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

// Snow on bridge:
// Not merged into a single lightmap because there is terrain brushes below it
// No landmines because it is solid, but I keep the surfaceparm
textures/1944_huertgen_xmas/snow_bridge
{
    qer_editorimage textures/editor_image/terrain1.tga
    // ************************************************************************
    q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
    q3map_lightmapAxis z
    q3map_lightmapSampleSize 32
    q3map_lightmapSize 512 512
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
    q3map_tcMod rotate 37
    // ************************************************************************
    surfaceparm snowsteps
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

// ****************************************************************************
// ****************************************************************************
// ****************************************************************************

textures/1944_huertgen_xmas/snow_dirt_nolandmine
{
    qer_editorimage textures/editor_image/terrain5.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    surfaceparm snowsteps
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

// ****************************************************************************
// ****************************************************************************
// ****************************************************************************

textures/1944_huertgen_xmas/terrain_base_nomerge
{
    q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
    q3map_lightmapAxis z
    q3map_lightmapSampleSize 32
    q3map_lightmapSize 512 512
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
    q3map_tcMod rotate 37
}

textures/1944_huertgen_xmas/snow_dirt_nomerge
{
    qer_editorimage textures/editor_image/terrain6.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base_nomerge
    // ************************************************************************
    surfaceparm landmine
    surfaceparm snowsteps
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/snow_dirt_nolandmine_nomerge
{
    qer_editorimage textures/editor_image/terrain7.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base_nomerge
    // ************************************************************************
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

// ****************************************************************************
// ****************************************************************************
// ****************************************************************************

textures/1944_huertgen_xmas/terrain0to1
{
    qer_editorimage textures/editor_image/terrain0to1.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    {
        map textures/snow_sd/bigrock_rounded_faint.tga
        rgbGen identity
    }
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        alphaGen vertex
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/terrain0to2
{
    qer_editorimage textures/editor_image/terrain0to2.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    {
        map textures/snow_sd/bigrock_rounded_faint.tga
        rgbGen identity
    }
    {
        map textures/snow_sd/s_grass_ml03b_big.jpg
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        alphaGen vertex
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen_xmas/terrain1to2
{
    qer_editorimage textures/editor_image/terrain1to2.tga
    // ************************************************************************
    q3map_baseShader textures/1944_huertgen_xmas/terrain_base
    // ************************************************************************
    surfaceparm landmine
    surfaceparm grasssteps
    {
        map textures/snow_sd/s_dirt_m03i_2_big.tga
        rgbGen identity
    }
    {
        map textures/snow_sd/s_grass_ml03b_big.jpg
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        alphaGen vertex
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}


// *********************************************
// **************** Sky Shaders ****************
// *********************************************

textures/1944_huertgen_xmas/fog
{
    qer_editorimage textures/sfx/fog_grey1.tga
    fogparms ( 0.6 0.6 0.6 ) 4096   // 4096 like worldspawn keys
    surfaceparm fog
    surfaceparm nodraw
    surfaceparm nonsolid
    surfaceparm trans
}

textures/1944_huertgen_xmas/sky
{
    nocompress
    qer_editorimage textures/skies/sky_6.tga
    q3map_nofog
    q3map_globaltexture
    q3map_lightsubdivide 256
    q3map_skylight 60 3 // 65: Quotidian (Used in Fuel Dump Christmas), 90: Railgun
    q3map_sunExt 0.3 0.3 0.45 60 220 60 3 16
    skyparms - 200 -
    surfaceparm nodlight
    surfaceparm noimpact
    surfaceparm nolightmap
    surfaceparm sky
    {
        map textures/skies_sd/wurzburg_clouds.tga
        tcMod scale 2.5 2.5
        tcMod scroll 0.003 -0.0015
        rgbGen identityLighting
    }
    {
        clampmap textures/skies_sd/goldrush_mask.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        tcMod scale 0.956 0.956
        tcMod transform 1 0 0 1 -1 -1
        rgbGen identitylighting
    }
}


// *********************************************
// *************** Forest Shader ***************
// *********************************************

textures/1944_huertgen_xmas/bunkerdoor
{
    qer_editorimage textures/1944_huertgen_xmas/bunkerdoor.tga
    noMipMaps
    surfaceparm trans
    surfaceparm woodsteps
    surfaceparm pointlight
    surfaceparm alphashadow
    {
        map textures/1944_huertgen_xmas/bunkerdoor.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
}

textures/1944_huertgen_xmas/forest_brambles
{
    qer_trans 0.95
    qer_alphafunc greater 0.5
    qer_editorimage textures/1944_huertgen_xmas/forest_brambles.tga

    cull none
    noPicMip
    polygonOffset

    surfaceparm trans
    surfaceparm nomarks
    surfaceparm pointlight
    surfaceparm alphashadow
    {
        map textures/1944_huertgen_xmas/forest_brambles.tga
        alphaFunc GE128
    }
    {
        map textures/fueldump_night/meshlight_1.tga
        alphaFunc GE128
        blendfunc add
        rgbGen wave sin 1 1 0 0.25
    }
    {
        map textures/fueldump_night/meshlight_1.tga
        alphaFunc GE128
        blendfunc add
        rgbGen wave sin 1 1 0 0.2
    }
    {
        map textures/fueldump_night/meshlight_2.tga
        alphaFunc GE128
        blendfunc add
        rgbGen wave sin 2 2 3 0.15
    }
    {
        map textures/fueldump_night/meshlight_2.tga
        alphaFunc GE128
        blendfunc add
        rgbGen wave sin 1 2 2 0.13
    }
}

textures/1944_huertgen_xmas/s_gun01_right
{
    surfaceparm metalsteps
    implicitMap -
}

textures/1944_huertgen_xmas/snow
{
    qer_editorimage textures/common/terrain_snow.tga
    // ************************************************************************
    q3map_lightmapaxis z
    q3map_lightmapsize 512 512
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
    q3map_tcMod rotate 37
    q3map_tcMod scale 1 1
    // ************************************************************************
    surfaceparm snowsteps
    {
        map textures/snow_sd/snow_var01_big.tga
        rgbgen identity
    }
    {
        lightmap $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbgen identity
    }
    {
        map textures/detail_sd/snowdetail.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbgen identity
        tcMod scale 5 5
        detail
    }
}

textures/1944_huertgen_xmas/snow_blending
{
    qer_editorimage textures/editor_image/terrain_snow_blend.tga
    // ************************************************************************
    q3map_lightmapaxis z
    q3map_lightmapsize 512 512
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
    q3map_tcMod rotate 37
    q3map_tcMod scale 1 1
    // ************************************************************************
    surfaceparm snowsteps
    {
        map textures/snow_sd/snow_var01_big.tga
        rgbgen identity
    }
    {
        map textures/temperate_sd/dirt_m03icmp_brown.jpg
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        alphaGen vertex
        rgbGen identity
        tcMod scale 4 4
    }
    {
        lightmap $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbgen identity
    }
    {
        map textures/detail_sd/snowdetail.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbgen identity
        tcMod scale 5 5
        detail
    }
}

textures/1944_huertgen_xmas/concrete
{
    qer_editorimage textures/editor_image/concrete
    // ************************************************************************
    q3map_lightmapaxis z
    q3map_lightmapsize 512 512
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
    q3map_tcMod rotate 37
    q3map_tcMod scale 1 1
    // ************************************************************************
    {
        map textures/miltary_wall/concrete_c07bcmp.jpg
        rgbgen identity
        tcMod scale 2 2
    }
    {
        lightmap $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbgen identity
    }
}

textures/1944_huertgen_xmas/snow2concrete_blend
{
    qer_editorimage textures/editor_image/snow2concrete_blend.tga
    // ************************************************************************
    q3map_lightmapaxis z
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
    q3map_tcMod rotate 37
    q3map_tcMod scale 1 1
    // ************************************************************************
    {
        map textures/snow_sd/snow_var01_big.tga
        rgbgen identity
    }
    {
        map textures/miltary_wall/concrete_c07bcmp.jpg
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        alphaGen vertex
        rgbGen identity
        tcMod scale 2 2
    }
    {
        lightmap $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbgen identity
    }
    {
        map textures/detail_sd/snowdetail.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbgen identity
        tcMod scale 5 5
        detail
    }
}

textures/1944_huertgen_xmas/snow_wall_1
{
    qer_editorimage textures/1944_huertgen_xmas/snow_wall_1.jpg
    implicitMap -
}

textures/1944_huertgen_xmas/snow_wall_2
{
    qer_editorimage textures/1944_huertgen_xmas/snow_wall_2.jpg
    implicitMap -
}

textures/1944_huertgen_xmas/riverbed
{
    qer_editorimage textures/stone/mxdebri0_riverbed.tga
    // ************************************************************************
    q3map_lightmapaxis z
    q3map_nonPlanar
    q3map_shadeAngle 179
    q3map_lightmapsize 512 512
    q3map_tcGen ivector ( 128 0 0 ) ( 0 128 0 )
    // ************************************************************************
    {
        map textures/stone/mxdebri0_riverbed.tga
        rgbgen identity
    }
    {
        lightmap $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbgen identity
    }
}

textures/1944_huertgen_xmas/river_edge
{
    qer_editorimage textures/snow_sd/river_edge_snowy.tga

    q3map_nonPlanar
    q3map_shadeAngle 120
    q3map_tcMod translate 0.0 0.48
    surfaceparm trans
    surfaceparm nomarks
    surfaceparm nonsolid
    surfaceparm pointlight
    polygonOffset
    sort decal

    // ************************************************************************
    q3map_tcGen ivector ( 256 0 0 ) ( 0 0 256 ) // Projected on x from z (along y)
    // ************************************************************************
    {
        map textures/snow_sd/river_edge_snowy.tga
        blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
        rgbGen identity
    }
}

textures/1944_huertgen_xmas/wood_2
{
    qer_editorimage textures/1944_huertgen_xmas/wood_2.jpg
    surfaceparm woodsteps
    implicitMap -
}

textures/1944_huertgen_xmas/wood_3
{
    qer_editorimage textures/1944_huertgen_xmas/wood_3.jpg
    surfaceparm woodsteps
    implicitMap -
}

textures/1944_huertgen_xmas/wood_4
{
    qer_editorimage textures/1944_huertgen_xmas/wood_4.jpg
    surfaceparm woodsteps
    implicitMap -
}


// *********************************************
// *************** Model Shaders ***************
// *********************************************

models/1944_huertgen/brambles
{
    qer_alphafunc greater 0.5
    qer_editorimage models/1944_huertgen/brambles.tga

    noPicMip
    cull disable
    sort seethrough

    surfaceparm trans
    surfaceparm nomarks
    surfaceparm pointlight
    surfaceparm alphashadow
    {
        map models/1944_huertgen/brambles.tga
        alphaFunc GE128
        rgbGen exactVertex
        alphaGen vertex
    }
}

models/1944_huertgen/brambles_2
{
    qer_alphafunc greater 0.5
    qer_editorimage models/1944_huertgen/brambles.tga

    noPicMip
    cull disable
    sort seethrough

    surfaceparm trans
    surfaceparm nomarks
    surfaceparm pointlight
    surfaceparm alphashadow
    {
        map models/1944_huertgen/brambles.tga
        alphaFunc GE128
        rgbGen exactVertex
        alphaGen vertex
    }
}

models/1944_huertgen/brambles_3
{
    qer_alphafunc greater 0.5
    qer_editorimage models/1944_huertgen/brambles.tga

    noPicMip
    cull disable
    sort seethrough

    surfaceparm trans
    surfaceparm nomarks
    surfaceparm pointlight
    surfaceparm alphashadow
    {
        map models/1944_huertgen/brambles.tga
        alphaFunc GE128
        rgbGen exactVertex
        alphaGen vertex
    }
}

models/1944_huertgen/snow_foliage
{
    qer_alphafunc greater 0.5
    qer_editorimage textures/1944_huertgen_xmas/forest_brambles.tga

    noPicMip
    cull disable
    sort seethrough

    surfaceparm trans
    surfaceparm nomarks
    surfaceparm pointlight
    surfaceparm alphashadow
    {
        map textures/1944_huertgen_xmas/forest_brambles.tga
        alphaFunc GE128
        rgbGen exactVertex
        alphaGen vertex
    }
}


//==========================================================================
// Various terrain decals textures
//==========================================================================

textures/1944_huertgen_xmas/snow_track03
{
    qer_editorimage textures/snow_sd/snow_track03.tga
    q3map_nonPlanar
    q3map_shadeAngle 120
    surfaceparm trans
    surfaceparm nonsolid
    surfaceparm pointlight
    surfaceparm nomarks
    surfaceparm snowsteps
    surfaceparm landmine
    polygonOffset

    sort decal

    {
        map textures/snow_sd/snow_track03.tga
        blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
        rgbGen identity
    }
}

textures/1944_huertgen_xmas/snow_track03_end
{
    qer_editorimage textures/snow_sd/snow_track03_end.tga
    q3map_nonPlanar
    q3map_shadeAngle 120
    surfaceparm trans
    surfaceparm nonsolid
    surfaceparm pointlight
    surfaceparm nomarks
    surfaceparm snowsteps
    surfaceparm landmine
    polygonOffset

    sort decal

    {
        map textures/snow_sd/snow_track03_end.tga
        blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
        rgbGen identity
    }
}


//==========================================================================
// Misc from [UJE] Xmas map series
//==========================================================================

textures/1944_huertgen_xmas/lampje_rood
{
    qer_editorimage textures/UJE_goldrush/lampje_rood.tga
    q3map_surfacelight 50
    surfaceparm nonsolid
    surfaceparm trans
    surfaceparm nolightmap
    surfaceparm nomarks
    nofog
    nomipmaps
    nopicmip
    cull none
    deformVertexes autosprite
    {
        clampmap textures/UJE_goldrush/lampje_rood.tga
        rgbGen wave sin 0 1 0.3 0.6
        blendfunc add
        tcMod stretch sin 1.0 0.1 0.5 0.5
    }
}

textures/1944_huertgen_xmas/lampje_geel
{
    qer_editorimage textures/UJE_goldrush/lampje_geel.tga
    q3map_surfacelight 50
    surfaceparm nonsolid
    surfaceparm trans
    surfaceparm nolightmap
    surfaceparm nomarks
    nofog
    nomipmaps
    nopicmip
    cull none
    deformVertexes autosprite
    {
        clampmap textures/UJE_goldrush/lampje_geel.tga
        rgbGen wave sin 0 1 0 0.5
        blendfunc add
        tcMod stretch sin 1.0 0.1 0.5 0.5
    }
}

textures/1944_huertgen_xmas/lampje_groen
{
    qer_editorimage textures/UJE_goldrush/lampje_groen.tga
    q3map_surfacelight 50
    surfaceparm nonsolid
    surfaceparm trans
    surfaceparm nolightmap
    surfaceparm nomarks
    nofog
    nomipmaps
    nopicmip
    cull none
    deformVertexes autosprite
    {
        clampmap textures/UJE_goldrush/lampje_groen.tga
        rgbGen wave sin 0 1 0.7 0.3
        blendfunc add
        tcMod stretch sin 1.0 0.1 0.5 0.5
    }
}

textures/1944_huertgen_xmas/lampje_blauw
{
    qer_editorimage textures/UJE_goldrush/lampje_blauw.tga
    q3map_surfacelight 50
    surfaceparm nonsolid
    surfaceparm trans
    surfaceparm nolightmap
    surfaceparm nomarks
    nofog
    nomipmaps
    nopicmip
    cull none
    deformVertexes autosprite
    {
        clampmap textures/UJE_goldrush/lampje_blauw.tga
        rgbGen wave sin 0 1 0.7 0.3
        blendfunc add
        tcMod stretch sin 1.0 0.1 0.5 0.5
    }
}

// Modified to be light-emitting
textures/1944_huertgen_xmas/rood
{
    q3map_lightImage textures/UJE_goldrush/rood.jpg
    qer_editorImage textures/UJE_goldrush/rood.jpg
    q3map_surfaceLight 256
    {
        map textures/UJE_goldrush/rood.jpg
        tcGen environment
        blendfunc GL_ONE GL_ONE
    }
}


//==========================================================================
// Misc from bulge_b1
//==========================================================================

models/mapobjects/tanks_sd/jagdpanther_snow
{
    qer_editorimage models/mapobjects/tanks_sd/jagdpanther_snow.tga
    {
        map models/mapobjects/tanks_sd/jagdpanther_snow.tga
        rgbGen lightingDiffuse
    }
}


//==========================================================================
// Misc from Supply (Winter Edition)
//==========================================================================

models/supply_we/blitz_sd_body_s
{
    qer_editorimage models/supply_we/blitz_sd_s2.tga
    {
        map models/supply_we/blitz_sd_s2.tga
        rgbGen lightingDiffuse
    }
}

models/supply_we/blitz_sd_windows_s
{
    qer_editorimage models/supply_we/blitz_sd_s2.tga
    {
        map textures/effects/envmap_slate.tga
        rgbGen lightingdiffuse
        tcGen environment
    }
    {
        map models/supply_we/blitz_sd_s2.tga
        blendFunc GL_ONE GL_ONE_MINUS_SRC_ALPHA
        rgbGen lightingDiffuse
    }
}
