// *********************************************
// ******* 1944 Huertgen Forest Shaders ********
// *********** By Kommando & Mateos ************
// ********* Last Update: 21 Aug. 2014 *********
// *********************************************

// *********************************************
// ************ Custom Icon Shaders ************
// *********************************************

gfx/1944_huertgen/cm_aagun
{
	noMipMaps
	noCompress
	{
		map gfx/1944_huertgen/cm_aagun.tga
		depthFunc equal
		blendFunc blend
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/1944_huertgen/cm_axisammoroom
{
	noMipMaps
	noCompress
	{
		map gfx/1944_huertgen/cm_axisammoroom.tga
		depthFunc equal
		blendFunc blend
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/1944_huertgen/cm_axispath
{
	noMipMaps
	noCompress
	{
		map gfx/1944_huertgen/cm_axispath.tga
		depthFunc equal
		blendFunc blend
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/1944_huertgen/cm_blast
{
	noMipMaps
	noCompress
	{
		map gfx/1944_huertgen/cm_blast.tga
		depthFunc equal
		blendFunc blend
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/1944_huertgen/cm_truckyardgate
{
	noMipMaps
	noCompress
	{
		map gfx/1944_huertgen/cm_truckyardgate.tga
		depthFunc equal
		blendFunc blend
		rgbGen vertex
		alphaGen vertex
	}
}


// *********************************************
// ************** Terrain Shaders **************
// *********************************************

textures/1944_huertgen/alpha_000
{
	qer_trans 0.95
	qer_editorimage textures/common/alpha_0.tga
	q3map_alphaMod volume
	q3map_alphaMod set 0.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/1944_huertgen/alpha_100
{
	qer_trans 0.95
	qer_editorimage textures/common/alpha_100.tga
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
}

textures/1944_huertgen/terrain_base
{
    q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapAxis z
	q3map_lightmapMergable
	q3map_lightmapSampleSize 32
	q3map_lightmapSize 512 512
	q3map_nonPlanar
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_tcMod rotate 37
}

textures/1944_huertgen/forest_floor
{
	qer_editorimage textures/editor_image/terrain2.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
    // ************************************************************************
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/1944_huertgen/forest_floor.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/bigrock_rounded_faint
{
	qer_editorimage textures/editor_image/terrain0.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
    // ************************************************************************
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/snow_dirt
{
	qer_editorimage textures/editor_image/terrain1.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
    // ************************************************************************
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/1944_huertgen/snow_dirt.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/snow_dirt_nolandmine
{
	qer_editorimage textures/editor_image/terrain5.tga
	// ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
	// ************************************************************************
	surfaceparm gravelsteps
	{
		map textures/1944_huertgen/snow_dirt.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

// ****************************************************************************
// ****************************************************************************
// ****************************************************************************

textures/1944_huertgen/terrain_base_nomerge
{
    q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapAxis z
	q3map_lightmapSampleSize 32
	q3map_lightmapSize 512 512
	q3map_nonPlanar
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_tcMod rotate 37
}

textures/1944_huertgen/snow_dirt_nomerge
{
	qer_editorimage textures/editor_image/terrain6.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base_nomerge
    // ************************************************************************
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/1944_huertgen/snow_dirt.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/snow_dirt_nolandmine_nomerge
{
	qer_editorimage textures/editor_image/terrain7.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base_nomerge
    // ************************************************************************
	{
		map textures/1944_huertgen/snow_dirt.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

// ****************************************************************************
// ****************************************************************************
// ****************************************************************************

textures/1944_huertgen/terrain0to1
{
	qer_editorimage textures/editor_image/terrain0to1.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
    // ************************************************************************
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		rgbGen identity
	}
	{
		map textures/1944_huertgen/snow_dirt.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/terrain0to2
{
	qer_editorimage textures/editor_image/terrain0to2.tga
	// ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
    // ************************************************************************
	{
		map textures/snow_sd/bigrock_rounded_faint.tga
		rgbGen identity
	}
	{
		map textures/1944_huertgen/forest_floor.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/terrain1to2
{
	qer_editorimage textures/editor_image/terrain1to2.tga
	// ************************************************************************
	q3map_baseShader textures/1944_huertgen/terrain_base
    // ************************************************************************
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/1944_huertgen/snow_dirt.tga
		rgbGen identity
	}
	{
		map textures/1944_huertgen/forest_floor.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}


// *********************************************
// **************** Sky Shaders ****************
// *********************************************

textures/1944_huertgen/forest_sky
{
	qer_editorimage textures/1944_huertgen/forest_topclouds.tga
	q3map_noFog
	q3map_skylight 50 3
	q3map_lightrgb 0.7 0.8 0.85
	q3map_sun 1 .96 .87 180 180 30
	noCompress
	surfaceparm sky
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap

	sunshader textures/1944_huertgen/forest_sun
	skyparms textures/skies_sd/wurzburg_env/sky 512 -

	{
		fog off
		map textures/1944_huertgen/forest_topclouds.tga
		tcMod scale 2.5 2.5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/1944_huertgen/forest_sky_mask.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		// rgbGen identityLighting
		//rgbGen const ( 0.6 0.6 0.6 )
		rgbGen const ( 0.4 0.4 0.4 )
	}
}

textures/1944_huertgen/forest_sun
{
	noFog
	cull none
	q3map_noFog
	{
		map textures/1944_huertgen/forest_sun.tga	// +KOMMANDO+ forgot to update this one, fixed.
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen identityLighting
	}
}

textures/1944_huertgen/forest_fog				// _fog value inside Worldspawn properties
{
	qer_editorimage textures/sfx/fog_grey1.tga

	surfaceparm fog
	surfaceparm trans
	surfaceparm nodraw
	surfaceparm nonsolid

	fogparms ( 0.4 0.4 0.4 ) 11904
}


// *********************************************
// *************** Water Shaders ***************
// *********************************************

textures/1944_huertgen/forest_water
{
	qer_trans .99
	qer_editorimage textures/1944_huertgen/forest_water.tga
	q3map_globaltexture
	nofog
	noCompress
	cull disable
	surfaceparm trans
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nonsolid
	waterfogvars ( 0.1 0.1 0.1 ) 300
	{
		fog on
		map $lightmap
		blendFunc GL_dst_color GL_zero
		rgbGen identity
	}
	{
		map textures/1944_huertgen/forest_water.jpg
		fog on
		rgbGen identity
		tcMod scale .4 .3
		tcMod scroll .075 -.025
		tcMod stretch sin 1 .005 0 .06
	}
	{
		map textures/1944_huertgen/forest_river.tga
		rgbGen identity
		tcMod scale -.12 .2
		blendFunc GL_dst_color GL_one
	}
}

textures/1944_huertgen/forest_waternodraw
{
	qer_trans .5
	qer_editorimage textures/1944_huertgen/forest_waternodraw.tga
	surfaceparm fog
	surfaceparm water
	surfaceparm nodraw

	fogparms ( 0.1 0.1 0.1 ) 1000
}


// *********************************************
// *************** Forest Shader ***************
// *********************************************

textures/1944_huertgen/bunkerdoor
{
	qer_editorimage textures/1944_huertgen/bunkerdoor.tga
	noMipMaps
	surfaceparm trans
	surfaceparm woodsteps
	surfaceparm pointlight
	surfaceparm alphashadow
	{
		map textures/1944_huertgen/bunkerdoor.tga
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	//implicitMask textures/1944_huertgen/bunkerdoor.tga
}

textures/1944_huertgen/forest_brambles
{
	qer_trans 0.95
    qer_alphafunc greater 0.5
	qer_editorimage textures/1944_huertgen/forest_brambles.tga

	noPicMip
	polygonOffset

	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow

	implicitMask -
}

textures/1944_huertgen/forest_brambles_2
{
	qer_trans 0.95
    qer_alphafunc greater 0.5
	qer_editorimage textures/1944_huertgen/forest_brambles_2.tga

	noPicMip
	polygonOffset

	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow

	implicitMask -
}

textures/1944_huertgen/road
{
	qer_editorimage textures/temperate_sd/dirt_m03icmp_brown.jpg
    // ************************************************************************
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapAxis z
	q3map_lightmapMergable
	q3map_lightmapSampleSize 32
	q3map_lightmapSize 512 512
    q3map_shadeAngle 120
	q3map_nonPlanar
    // ************************************************************************
	surfaceparm landmine
	surfaceparm gravelsteps
	implicitMap textures/temperate_sd/dirt_m03icmp_brown.jpg
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/roof_1
{
	qer_editorimage textures/1944_huertgen/roof_1.jpg
	surfaceparm roofsteps
	implicitMap -
}

textures/1944_huertgen/s_gun01_right
{
	surfaceparm metalsteps
	implicitMap -
}

textures/1944_huertgen/snow_road
{
	qer_editorimage textures/1944_huertgen/snow_road.jpg
    // ************************************************************************
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapAxis z
	q3map_lightmapMergable
	q3map_lightmapSampleSize 32
	q3map_lightmapSize 512 512
    q3map_shadeAngle 120
	q3map_nonPlanar
    // ************************************************************************
	surfaceparm landmine
	surfaceparm gravelsteps
    {
		map textures/1944_huertgen/snow_road.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/snow_wall_1
{
	qer_editorimage textures/1944_huertgen/snow_wall_1.jpg
	implicitMap -
}

textures/1944_huertgen/snow_wall_2
{
	qer_editorimage textures/1944_huertgen/snow_wall_2.jpg
	implicitMap -
}

textures/1944_huertgen/wood_1
{
	qer_editorimage textures/1944_huertgen/wood_1.jpg
	polygonOffset
	surfaceparm woodsteps
	implicitMap -
}

textures/1944_huertgen/wood_2
{
	qer_editorimage textures/1944_huertgen/wood_2.jpg
	surfaceparm woodsteps
	implicitMap -
}

textures/1944_huertgen/wood_3
{
	qer_editorimage textures/1944_huertgen/wood_3.jpg
	surfaceparm woodsteps
	implicitMap -
}

textures/1944_huertgen/wood_4
{
	qer_editorimage textures/1944_huertgen/wood_4.jpg
	surfaceparm woodsteps
	implicitMap -
}


// *********************************************
// *************** Model Shaders ***************
// *********************************************

models/1944_huertgen/brambles
{
	qer_alphafunc greater 0.5
	qer_editorimage models/1944_huertgen/brambles.tga

	noPicMip
	cull disable
	sort seethrough

	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow

	{
		map models/1944_huertgen/brambles.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

models/1944_huertgen/brambles_2
{
	qer_alphafunc greater 0.5
	qer_editorimage models/1944_huertgen/brambles.tga

	noPicMip
	cull disable
	sort seethrough

	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow

	{
		map models/1944_huertgen/brambles.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

models/1944_huertgen/brambles_3
{
	qer_alphafunc greater 0.5
	qer_editorimage models/1944_huertgen/brambles.tga

	noPicMip
	cull disable
	sort seethrough

	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow

	{
		map models/1944_huertgen/brambles.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}

textures/1944_huertgen/jagdpanther_forest
{
	qer_editorimage textures/1944_huertgen/jagdpanther_forest.tga
	{
		map textures/1944_huertgen/jagdpanther_forest.tga
		rgbGen lightingDiffuse
	}
}

textures/1944_huertgen/jagdpanther_additions_forest
{
	qer_editorimage textures/1944_huertgen/jagdpanther_additions_forest.tga
	{
		map textures/1944_huertgen/jagdpanther_additions_forest.tga
		rgbGen lightingDiffuse
	}
}

models/1944_huertgen/snow_foliage
{
	qer_alphafunc greater 0.5
	qer_editorimage textures/1944_huertgen/forest_brambles.tga

	noPicMip
	cull disable
	sort seethrough

	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm alphashadow

	{
		map textures/1944_huertgen/forest_brambles.tga
		alphaFunc GE128
		rgbGen exactVertex
		alphaGen vertex
	}
}


// *********************************************
// ********** High-Resolution Shadows **********
// *********************************************

textures/1944_huertgen/highres_shadows
{
	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	q3map_lightmapAxis z
	q3map_lightmapSampleSize 4
	q3map_lightmapSize 512 512
	q3map_nonPlanar
}

textures/1944_huertgen/forest_floor_light
{
	qer_editorimage textures/editor_image/terrain4.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/highres_shadows
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_tcMod rotate 37
    // ************************************************************************
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/1944_huertgen/forest_floor.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/snow_dirt_light
{
	qer_editorimage textures/editor_image/terrain3.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/highres_shadows
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_tcMod rotate 37
    // ************************************************************************
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/1944_huertgen/snow_dirt.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/terrain1to2_light
{
	qer_editorimage textures/editor_image/terrain3to4.tga
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/highres_shadows
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_tcMod rotate 37
    // ************************************************************************
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/1944_huertgen/snow_dirt.jpg
		rgbGen identity
	}
    {
		map textures/1944_huertgen/forest_floor.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}

textures/1944_huertgen/snow_road_light
{
	qer_editorimage textures/1944_huertgen/snow_road.jpg
    // ************************************************************************
	q3map_baseShader textures/1944_huertgen/highres_shadows
    // ************************************************************************
	surfaceparm landmine
	surfaceparm gravelsteps
	{
		map textures/1944_huertgen/snow_road.jpg
		rgbGen identity
	}
	{
        map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
    {
        map textures/detail_sd/snowdetail_heavy.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
        rgbGen identity
        detail
    }
}
