//****************************************************//
//									//
//	siege.shader for GTKRadiant			//
//	by Amethyst7 - 06.12.2001				//
//									//
//****************************************************//

//textures/110_factory/skybox/skybox
//{
//	qer_editorimage textures/110_factory/skybox/siege
//	surfaceparm noimpact
//	surfaceparm nolightmap
//	q3map_sun 1.00 1.00 0.965 110 199 49
//	q3map_surfacelight 70
//	skyparms textures/110_factory/skybox/siege - -
//	{
//		map textures/110_factory/skybox/clouds.jpg
//		blendFunc filter
//		tcMod scroll 0.005 0.005
//		tcMod scale 2 2
//	}
//}

textures/110_factory/terrain_base
{
	nopicmips
	q3map_lightmapmergable
	q3map_lightmapaxis z
	q3map_shadeangle 179
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
}

textures/110_factory/balloon_green
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/110_factory/balloon_red
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/110_factory/bars_m01
{
	qer_trans 0.5
	cull disable
	nomipmaps
	nopicmip
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask -
}

textures/110_factory/debri_m05
{
	surfaceparm gravelsteps
	surfaceparm landmine	
	implicitMap -
}

textures/110_factory/germancross
{
	cull disable
	nomipmaps
	nopicmip
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	tessSize 64
	implicitBlend -
}

textures/110_factory/grate
{
	surfaceparm metalsteps
	implicitMap -
}

textures/110_factory/sand_gravels_bright
{
	qer_editorimage textures/110_factory/sand_gravels_bright.tga
	q3map_nonplanar
	q3map_shadeangle 179
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/110_factory/sand_gravels_bright.tga
		blendFunc filter
	}

	surfaceparm gravelsteps
	surfaceparm landmine	
}

textures/110_factory/sand_disturb_desert
{
	qer_editorimage textures/110_factory/sand_disturb_desert.tga
	q3map_nonplanar
	q3map_shadeangle 179
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/110_factory/sand_disturb_desert.tga
		blendFunc filter
	}

	surfaceparm gravelsteps
	surfaceparm landmine	
}

textures/110_factory/sea_water
{
	qer_editorimage textures/110_factory/water_surface.jpg
	qer_trans .8
	
	q3map_globalTexture
	cull disable
	nocompress
	//nofog
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
	tessSize 256
	deformVertexes wave 1317 sin 0 4 0 0.15
 	deformVertexes wave 317 sin 0 2 0 0.30
	
	{
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		
		tcGen environment
		depthWrite
		tcmod scale .5 .5
	}
	
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc blend
		rgbGen identity
		alphaGen const .85
		tcmod scroll 0.005 -0.03
		tcmod scale .5 .5
	}
	{
		map textures/110_factory/water_surface.jpg
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.15 0.1 0.1 0.15
		alphaGen vertex
		tcMod turb 0 0.05 0 0.15
		tcmod scale .5 .5
		tcmod scroll -0.01 -0.08
	}
	{ 
		map textures/liquids_sd/sea_bright_na.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave sin 0.2 0.1 0 0.2
		alphaGen vertex
		tcMod turb 0 0.05 0.5 0.15
		tcmod scale .5 .5
		tcmod scroll 0.01 -0.09
	}
	
}

textures/110_factory/sky
{
	nocompress
	qer_editorimage textures/skies_sd/nero_bluelight.tga
	q3map_lightimage textures/skies_sd/siwa_clouds.tga
	
	q3map_sun 0.75 0.70 0.6 135 199 49
	q3map_skylight 75 3
	sunshader textures/skies_sd/siwasunbright
	
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nodlight
	surfaceparm sky

//	skyparms textures/110_factory/skybox/siege - -
	skyparms textures/skies_sd/wurzburg_env/sky 512 -
	{
		map textures/110_factory/skybox/clouds.jpg
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
}

textures/110_factory/sub_flag
{
	cull disable
	nomipmaps
	nopicmip
	deformVertexes wave 100 sin 0 4 0 .6
	deformVertexes wave 30 sin 0 4 0 .2
	nofog
	surfaceparm alphashadow
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	tessSize 64
	implicitBlend -
}

textures/110_factory/ter_sand_wave_desert
{
	qer_editorimage textures/110_factory/ter_sand_wave_desert.tga
	q3map_nonplanar
	q3map_shadeangle 179
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/110_factory/ter_sand_wave_desert.tga
		blendFunc filter
	}

	surfaceparm gravelsteps
	surfaceparm landmine	
}

textures/110_factory/translucent_blue
{
	qer_editorimage textures/common/dirtymirror.tga
	cull none
	surfaceparm glass
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/common/dirtymirror.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin 0.5 0.5 0 0.5
		tcgen environment
	}
	{
		map $whiteimage
		blendfunc filter
		rgbGen const ( 0.6 0.6 1.0 )
	}
}

// ======================================================================
// DotProduct2 Terrain blending
// ======================================================================
textures/110_factory/ter_sand2gravel
{
      qer_editorimage textures/110_factory/ter_sand2gravel.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	
	q3map_nonplanar
	q3map_shadeangle 179
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/110_factory/sand_disturb_desert.tga	// Primary
		rgbGen identity
	}
	{
		map textures/110_factory/ter_sand_gravels_bright.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/110_factory/ter_sand2wave
{
      qer_editorimage textures/110_factory/ter_sand2wave.tga
	surfaceparm gravelsteps
	surfaceparm landmine	
	
	q3map_nonplanar
	q3map_shadeangle 179
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/110_factory/sand_disturb_desert.tga	// Primary
		rgbGen identity
	}
	{
		map textures/110_factory/ter_sand_wave_desert.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/110_factory/ter_rock2gravel
{
      qer_editorimage textures/110_factory/ter_rock2gravel.tga
	surfaceparm gravelsteps
	
	q3map_nonplanar
	q3map_shadeangle 179
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/110_factory/rock_edged_smooth.tga	// Primary
		rgbGen identity
	}
	{
		map textures/110_factory/ter_sand_gravels_bright.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

textures/110_factory/ter_rock2wave
{
      qer_editorimage textures/110_factory/ter_rock2wave.tga
	surfaceparm gravelsteps
	
	q3map_nonplanar
	q3map_shadeangle 179
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )

	q3map_alphaMod dotproduct2 ( 0.0 0.0 0.75 )
	{
		map textures/110_factory/rock_edged_smooth.tga	// Primary
		rgbGen identity
	}
	{
		map textures/110_factory/ter_sand_wave_desert.tga	// Secondary
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GE128
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}

// ======================================================================
// Hong Phonged textures
// ======================================================================
textures/110_factory/ter_rock2
{
	q3map_nonplanar
	q3map_shadeangle 120
      qer_editorimage textures/110_factory/ter_rock2.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/110_factory/ter_rock2.tga
		blendFunc filter
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// distribution, in part or in whole, in any medium, permitted
// ======================================================================
//
// These shaders are not fixed to this directory location, they can
// be moved around. They exist here for convenience only.
//
textures/110_factory/alpha_000	// Primary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/110_factory/alpha_025
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.25
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/110_factory/alpha_050	// Perfect mix of both Primary + Secondary
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.50
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/110_factory/alpha_075
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.75
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/110_factory/alpha_085
{
	q3map_alphaMod volume
	q3map_alphaMod set 0.85
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/110_factory/alpha_100	// Secondary texture ONLY
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

