//////////////////////////////////////////////////////////////////////////
// Command map shaders for mml_claustro_v1

levelshots/mml_claustro_v1_cc_automap
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_claustro_v1_cc.tga
        depthFunc equal
        rgbGen identity
    }
}

levelshots/mml_claustro_v1_cc_trans
{
    nopicmip
    nocompress
    nomipmaps
    {
        clampmap levelshots/mml_claustro_v1_cc.tga
        blendfunc blend
        rgbGen identity
        alphaGen vertex
    }
}

//////////////////////////////////////////////////////////////////////////
// Skybox
textures/mml_claustro_v1/skybox
{
	qer_editorimage textures/skies_sd/goldrush_clouds.tga
	q3map_skylight 15 1
	q3map_sun 0.3 0.3 0.45 100 35 145
	nocompress
	sunshader textures/skies_sd/full_moon2
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	
	skyparms textures/skies_sd/wurzburg_env/sky 512 -
 
	
	{	fog off
		map textures/skies_sd/goldrush_clouds.tga
		tcMod scale 5 5
		tcMod scroll 0.0075 -0.015
		rgbGen identityLighting
	}


	{	fog off
		map textures/skies/nightsky1.jpg
		tcMod scale 10 10
		blendfunc add
		rgbGen identityLighting
	}

	{
		fog off
		clampmap textures/skies_sd/goldrush_mask.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		// rgbGen identityLighting
		//rgbGen const ( 0.6 0.6 0.6 ) 
		rgbGen const ( 0.4 0.4 0.4 ) 
	}
}

models/mapobjects/mml_claustro_v1/grass
{	
	surfaceparm alphashadow
	implicitmask -
}

//////////////////////////////////////////////////////////////////////////
// Ingame shaders
textures/mml_claustro_v1/red
{
	surfaceparm nolightmap
	nopicmip
	cull disable
	{
		map textures/mml_claustro_v1/red.tga
		rgbgen wave triangle -7.0 -10.0 3.0 0.4
		blendfunc add
	}
}

textures/mml_claustro_v1/grass
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3
	q3map_surfaceModel models/mapobjects/mml_claustro_v1/grass.md3 24 0.02 1.0 0.6 0 360 1
	surfaceparm grasssteps
	surfaceparm landmine

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90

	implicitmap textures/temperate_sd/master_grass_dirt3
}

textures/mml_claustro_v1/skybox_grass
{
	qer_editorimage textures/temperate_sd/master_grass_dirt3

	q3map_lightmapaxis z
	q3map_globalTexture 
	q3map_tcGen ivector ( 8 0 0 ) ( 0 8 0 )

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/temperate_sd/master_grass_dirt3.tga
		rgbGen identity
		blendfunc filter
	}
	{
		map textures/mml_claustro_v1/sky_shadow.tga
		tcMod scale 0.5 0.5
		tcMod scroll -0.0075 0.015
		rgbGen identity
		blendfunc filter
	}
}

textures/mml_claustro_v1/cave_wall
{
	q3map_nonplanar
	q3map_shadeAngle 160

	implicitMap -
}

textures/mml_claustro_v1/cave_floor
{
	qer_editorimage textures/stone/mxrock1aa.tga

	// Q3map2 properties
	q3map_nonplanar
	q3map_shadeAngle 90
	surfaceparm gravelsteps
	surfaceparm landmine

	implicitMap textures/stone/mxrock1aa.tga
}

textures/mml_claustro_v1/window_lit
{
    q3map_lightimage textures/mml_claustro_v1/wlight.b.tga
    qer_editorimage textures/mml_claustro_v1/wlight.tga
    q3map_surfacelight 450
    surfaceparm nomarks
    {
        map $lightmap
        rgbGen identity
    }
    {
        map textures/mml_claustro_v1/wlight.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/mml_claustro_v1/wlight.b.tga
        blendFunc GL_ONE GL_ONE
    }
}
