//**************************************************************
//***********************TERRAIN SHADERS************************
//**************************************************************

textures/saberpeak/terrain_base
{
	q3map_nonplanar
      q3map_shadeangle 179
	q3map_lightmapaxis z
	q3map_lightmapmergable
	q3map_lightmapsize 512 512
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_lightmapMergable
}

textures/saberpeak/terrain_0
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_1
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_dirtGrass.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_2
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_dirt.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_dirt.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_3
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rockwater1.jpg
	{
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_4
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rock1.jpg
	{
		map textures/SaberPeak_terrain/sp_rock1.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_5
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	q3map_notjunc
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
		rgbGen const ( 0.85 0.85 0.85 )
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_6
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/egypt_walls_sd/stucco09f.jpg
	{
		map textures/egypt_walls_sd/stucco09f.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_7
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rockgrass8.tga
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_8
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_pavement.jpg
	{
		map textures/SaberPeak_terrain/sp_pavement.jpg
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_0to1
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}



textures/saberpeak/terrain_0to3
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_0to4
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rock1.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_0to5
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
		rgbGen const ( 0.85 0.85 0.85 )
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_0to6
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
	}
	{
		map textures/egypt_walls_sd/stucco09f.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}



textures/saberpeak/terrain_1to2
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_dirtGrass.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_dirt.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_1to3
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_dirtGrass.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_1to4
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_dirtGrass.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rock1.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


textures/saberpeak/terrain_2to8
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_dirt.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_dirt.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_pavement.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_3to4
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rockwater1.jpg
	{
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rock1.jpg
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/saberpeak/terrain_3to5
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rockwater1.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_sand0.jpg
		rgbGen const ( 0.85 0.85 0.85 )
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


textures/saberpeak/terrain_3to7
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rockwater1.jpg
	surfaceparm landmine
	surfaceparm grasssteps
	{
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


textures/saberpeak/terrain_4to7
{
	q3map_baseshader textures/saberpeak/terrain_base
	qer_editorimage textures/SaberPeak_terrain/sp_rock1.jpg
	{
		map textures/SaberPeak_terrain/sp_rock1.jpg
	}
	{
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

//**************************************************************
//**************ADDITIONAL TERRAIN SHADERS**********************
//**************************************************************

textures/saberpeak/SP_rockboulder
{
	qer_editorimage textures/SaberPeak_terrain/sp_rock1.tga
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeangle 179
	q3map_clipmodel
	implicitmap textures/SaberPeak_terrain/sp_rock1.tga	
}

textures/saberpeak/SP_rockX
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockX.jpg 
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeangle 179
	q3map_lightmapmergable
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )
	q3map_clipmodel
	implicitmap textures/SaberPeak_terrain/sp_rock1.tga 
}

textures/saberpeak/SP_rockY
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockY.jpg 
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeangle 179
	q3map_lightmapmergable
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 )
	q3map_clipmodel
	implicitmap textures/SaberPeak_terrain/sp_rock1.tga 
}


//this is the shader used by the mountainSide.ase
//Do NOT modify...gives good grass distribution on the model
textures/saberpeak/SP_rockGrassY0
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockGrassY.jpg
	q3map_lightmapmergable
	q3map_forceMeta
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_alphaMod dotproduct2 ( 0.37 .92 .65 )
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga 
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		alphaFunc GE128 
		rgbGen identity 
		alphaGen Vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}


textures/saberpeak/SP_rockGrassY1
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockGrassY.jpg
	q3map_lightmapmergable
	q3map_forceMeta
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_alphaMod dotproduct2 ( -0.55 .97 -.35 )
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga 
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		alphaFunc GE128 
		rgbGen identity 
		alphaGen Vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_rockGrassY2
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockGrassY.jpg
	q3map_forceMeta
	q3map_lightmapmergable
	q3map_tcGen ivector ( 1024 0 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_alphaMod dotproduct2 ( 0.37 .85 -.65 )
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga 
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		alphaFunc GE128 
		rgbGen identity 
		alphaGen Vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_rockGrassX0
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockGrassX.jpg
	q3map_forceMeta
	q3map_lightmapmergable
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_alphaMod dotproduct2 ( 1 1 1 )

	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga 
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		alphaFunc GE128 
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_rockGrassX1
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockGrassX.jpg
	q3map_forceMeta
	q3map_lightmapmergable
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_alphaMod dotproduct2 ( .85 -1 1 )
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga 
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		alphaFunc GE128 
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_rockGrassX2
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockGrassX.jpg
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_lightmapmergable
	q3map_alphaMod dotproduct2 ( -.87 -.45 -.45 )
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga 
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockgrass8.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA 
		alphaFunc GE128 
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}


textures/saberpeak/SP_earthToRockZtoY
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_dirtToRockY.jpg
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_clipModel
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeAngle 179
	q3map_lightmapmergable
	surfaceparm landmine
	surfaceparm grasssteps
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0.0009765625 0 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}


textures/saberpeak/SP_earthToRockZtoX
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_dirtToRockX.jpg
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_clipModel
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeAngle 179
	q3map_lightmapmergable
	surfaceparm landmine
	surfaceparm grasssteps
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0 0.0009765625 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}


textures/saberpeak/SP_rockYtoX
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockXtoY.jpg
	q3map_lightmapmergable
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )
	q3map_clipModel
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeAngle 179 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0.0009765625 0 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_rockZtoY
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockZtoY.jpg
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_lightmapmergable
	q3map_clipModel
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeAngle 179 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0.0009765625 0 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_rockZtoX
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockZtoX.jpg
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_lightmapmergable
	q3map_clipModel
	q3map_forceMeta
	q3map_nonplanar 
	q3map_shadeAngle 179 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0 0.0009765625 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_waterToRockZtoY
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_waterToRockY.jpg
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_lightmapmergable
	q3map_clipModel
	q3map_nonplanar 
	q3map_forceMeta
	q3map_shadeAngle 179 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0.0009765625 0 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_waterToRockY
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_waterToRockY.jpg
	q3map_lightmapmergable
	q3map_forceMeta
	q3map_tcGen ivector ( 512 0 0 ) ( 0 0 512 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0.0009765625 0 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_waterToRockX
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_waterToRockY.jpg
	q3map_lightmapmergable
	q3map_forceMeta
	q3map_tcGen ivector ( 0 512 0 ) ( 0 0 512 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0 0.0009765625 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rockwater1.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}



textures/saberpeak/SP_sandToRockZtoX
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_sandToRockX.jpg
	q3map_lightmapmergable
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 179 
	q3map_forceMeta
	surfaceparm landmine
	surfaceparm grasssteps
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		tcGen vector ( 0 0.0009765625 0 ) ( 0 0 0.0009765625 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_sand0.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}


//same as fueldump.shader...just added playerclip and z axis projection
textures/saberpeak/SP_caveFloor
{
	surfaceparm gravelsteps
	q3map_tcGen ivector ( 256 0 0 ) ( 0 256 0 )
	q3map_nonplanar
	q3map_shadeangle 60
	q3map_clipModel
	q3map_forceMeta
	qer_editorimage textures/stone/mxrock1aa.tga
	surfaceparm nodamage
	surfaceparm landmine
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/stone/mxrock1aa.tga
		blendFunc filter
	}
}


textures/saberpeak/SP_caveDark
{
	q3map_nonplanar
	q3map_shadeangle 60
	q3map_clipModel
	q3map_forceMeta
	qer_editorimage textures/SaberPeak_terrain/sp_cave.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/SaberPeak_terrain/sp_cave.tga
		blendFunc filter
	}
}

textures/saberpeak/SP_rockToCave
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_rockToCave.jpg
	q3map_tcGen ivector ( 0 1024 0 ) ( 0 0 1024 )
	q3map_lightmapmergable
	q3map_clipModel
	q3map_nonplanar 
	q3map_shadeAngle 60 
	{ 
		map textures/stone/mxrock1aa.tga
		tcGen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_rock1.tga
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

textures/saberpeak/SP_dirtToCave
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_dirtToCave.jpg
	q3map_lightmapmergable
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm landmine
	surfaceparm grasssteps
	q3map_nonplanar 
	q3map_shadeAngle 179 
	surfaceparm landmine
	surfaceparm grasssteps
	{ 
		map textures/stone/mxrock1aa.tga
		tcGen vector ( 0.00390625 0 0 ) ( 0 0.00390625 0 )
		rgbGen identity 
	} 
	{ 
		map textures/SaberPeak_terrain/sp_dirtGrass.jpg
		blendFunc blend
		rgbGen identity 
		alphaGen vertex
	} 
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 	
}

//*************************END TERRAIN*******************************



//**************************************************
//****************Global and Misc Shaders **********
//**************************************************

textures/saberpeak/sp_chest
{
	qer_editorimage textures/SaberPeak_items/sp_chest.jpg
	surfaceparm wood
	implicitmap textures/SaberPeak_items/sp_chest.jpg
}


textures/saberpeak/sp_storeawning
{
	qer_editorimage textures/SaberPeak_structure/sp_storeawning.tga
	cull none
	implicitmap textures/SaberPeak_structure/sp_storeawning.tga
}

textures/saberpeak/SP_tracks
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_terrain/sp_tracks.tga
	surfaceparm grasssteps
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	polygonoffset
	surfaceparm trans
	{ 
		map textures/SaberPeak_terrain/sp_tracks.tga
		blendFunc blend
	} 
}

textures/saberpeak/SP_crate
{
	qer_editorimage textures/SaberPeak_items/sp_crate.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_items/sp_crate.jpg
}

textures/saberpeak/SP_shellbox
{
	qer_editorimage textures/SaberPeak_other/sp_shellbox.jpg
	surfaceparm wood
	implicitmap textures/SaberPeak_other/sp_shellbox.jpg
}

textures/saberpeak/SP_bunkercammo
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_other/SP_bunkercammo.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm grasssteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_other/SP_bunkercammo.tga
}

textures/saberpeak/SP_redroof
{
	qer_editorimage textures/SaberPeak_stone/SP_redroof.jpg
	surfaceparm roofsteps
	implicitmap textures/SaberPeak_stone/SP_redroof.jpg
}

textures/saberpeak/SP_palmLeaf
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_foliage/sp_sdpalm_leaves.tga
	cull disable
	polygonoffset
	surfaceparm grasssteps
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_foliage/sp_sdpalm_leaves.tga

}


textures/saberpeak/SP_vase
{
	q3map_nonplanar
	q3map_shadeangle 90
	qer_editorimage textures/SaberPeak_items/SP_vase.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_items/SP_vase.jpg
}

textures/saberpeak/SP_lamphandle
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_other/SP_lamphandle.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm metalsteps
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_other/SP_lamphandle.tga
}

textures/saberpeak/SP_lamp
{
	surfaceparm glass
	qer_editorimage textures/SaberPeak_other/SP_lamp.jpg
	implicitmap textures/SaberPeak_other/SP_lamp.jpg
}

textures/saberpeak/SP_fountain
{
	qer_editorimage textures/SaberPeak_stone/SP_fountain.jpg
	q3map_nonplanar
	q3map_shadeangle 179
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_fountain.jpg
}

textures/saberpeak/SP_mp40
{
	surfaceparm metalsteps
	qer_editorimage textures/SaberPeak_items/SP_mp40.jpg
	implicitmap textures/SaberPeak_items/SP_mp40.jpg
}



//**************************************************
//****************House 0 **************************
//**************************************************
textures/saberpeak/SP_house0decals
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_stone/SP_house0decals.tga
	polygonoffset
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm trans
	implicitMask textures/SaberPeak_stone/SP_house0decals.tga
}


//Shaders related to the Tavern Building
//**************************************
//******* Tavern ***********************
//**************************************

textures/saberpeak/SP_woodcolumn
{
	qer_editorimage textures/SaberPeak_wood/SP_woodcolumn.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_woodcolumn.jpg
}

textures/saberpeak/tavern_stool
{
	qer_editorimage textures/SaberPeak_wood/SP_woodstool.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_woodstool.jpg
}
textures/saberpeak/window_trim
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_structure/tavernwindowtrim.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_structure/tavernwindowtrim.tga
}

textures/saberpeak/SP_chain
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_other/SP_chainlink.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm metalsteps
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_other/SP_chainlink.tga
}

textures/saberpeak/SP_tavernsign
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_other/SP_tavernsign.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm woodsteps
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_other/SP_tavernsign.tga
}

//END TAVERN SHADERS


//Shaders related to the first house
//**************************************
//******* House #1 *********************
//**************************************

textures/saberpeak/SP_yellowmarble
{
	//q3map_notjunc
	qer_editorimage textures/SaberPeak_stone/SP_yellowmarble.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_yellowmarble.jpg
}

textures/saberpeak/SP_balconycolumn
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_stone/SP_balconycolumn.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm alphashadow
	surfaceparm trans
	implicitMask textures/SaberPeak_stone/SP_balconycolumn.tga
}

textures/saberpeak/SP_housefence
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_wood/SP_fence.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm woodsteps
	surfaceparm trans
	implicitMask textures/SaberPeak_wood/SP_fence.tga
}

//End shaders for house #1


//Shaders related to the second house
//**************************************
//******* House #2 (Axis spawn) ********
//**************************************

textures/saberpeak/SP_marblefloor
{
	qer_editorimage textures/SaberPeak_stone/SP_floormarble.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_floormarble.jpg
}

textures/saberpeak/SP_woodfloortiles
{
	q3map_notjunc
	qer_editorimage textures/SaberPeak_wood/SP_floorwood.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_floorwood.jpg
}
textures/saberpeak/SP_housewindow
{
	qer_editorimage textures/SaberPeak_structure/SP_housewindow.jpg
	surfaceparm glass
	implicitmap textures/SaberPeak_structure/SP_housewindow.jpg
}

textures/saberpeak/SP_interiorTrim
{
	qer_editorimage textures/SaberPeak_stone/SP_houseinteriorTrim.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_houseinteriorTrim.jpg
}

//necessary because above interiorTrim was causing all kinds of graphics bugs
textures/saberpeak/SP_interior
{
	qer_editorimage textures/SaberPeak_stone/SP_houseinterior.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_houseinterior.jpg
}

textures/saberpeak/SP_ceiling
{
	qer_editorimage textures/SaberPeak_stone/SP_houseinterior.jpg
	{
		map textures/SaberPeak_stone/SP_houseinterior.jpg
		rgbGen const ( 0.85 0.85 0.85 )
	}
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 
}

textures/saberpeak/SP_brownMarble
{
	qer_editorimage textures/SaberPeak_stone/SP_AxisMarble.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_AxisMarble.jpg
}

textures/saberpeak/SP_houseTrim
{
	qer_trans 0.85
	qer_editorimage textures\SaberPeak_stone\SP_housetrim.tga
	nomipmaps
	nopicmip
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm trans
	polygonoffset
	implicitMask textures\SaberPeak_stone\SP_housetrim.tga
	
}

textures/saberpeak/SP_burntwall
{
	qer_editorimage textures/SaberPeak_stone/SP_yellstcc_burnt.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_yellstcc_burnt.jpg
}

textures/saberpeak/SP_horsefair
{
	qer_editorimage textures/SaberPeak_other/SP_horsefair.jpg
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonoffset
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_other/SP_horsefair.jpg
}

textures/saberpeak/SP_floorrug
{
	qer_editorimage textures/SaberPeak_other/SP_rug.jpg
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonoffset
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_other/SP_rug.jpg
}

textures/saberpeak/SP_burntwall2
{
	qer_editorimage textures/SaberPeak_stone/SP_begstcc_burnt.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_begstcc_burnt.jpg
}

textures/saberpeak/SP_axisflag
{
	qer_trans 0.85
	qer_editorimage textures\SaberPeak_items\SP_axisFlag.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm trans
	deformVertexes wave 30 sin 2 5 0 0.3 
	implicitMask textures\SaberPeak_items\SP_axisFlag.tga
	
}

//End shaders for house #2

//Shaders related to the last house
//**************************************
//******* House #4 *********************
//**************************************

textures/saberpeak/SP_crawlplants
{
	qer_trans 0.85
	qer_editorimage textures\SaberPeak_foliage\SP_crawler.tga
	cull disable
	nomipmaps
	nopicmip
	polygonoffset
	surfaceparm grasssteps
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures\SaberPeak_foliage\SP_crawler.tga
}

textures/saberpeak/SP_wallstucco
{
	qer_editorimage textures/SaberPeak_stone/SP_wallstucco.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_wallstucco.jpg
}

textures/saberpeak/SP_Wallstuccbrick
{
	qer_editorimage textures/SaberPeak_stone/SP_Wallstuccbrick.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_Wallstuccbrick.jpg
}

//End shaders for house #4

//Shaders related to the fish store
//**************************************
//******* Fish Store (Axis Spawn #2) ***
//**************************************

textures/saberpeak/SP_sharkmouth
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_other/SP_sharkmouth.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm metalsteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_other/SP_sharkmouth.tga
}
	
textures/saberpeak/SP_fishnet
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_items/SP_fishnet1.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm playerclip
	surfaceparm grasssteps
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_items/SP_fishnet1.tga
}

textures/saberpeak/SP_basket
{
	qer_editorimage textures/SaberPeak_items/SP_basket.jpg
	surfaceparm roofsteps
	implicitmap textures/SaberPeak_items/SP_basket.jpg
}

textures/saberpeak/SP_fishinterior
{
	qer_editorimage textures/SaberPeak_stone/SP_fishinterior.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_fishinterior.jpg
}

textures/saberpeak/SP_fishouterwall
{
	qer_editorimage textures/SaberPeak_stone/SP_fishwall.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_fishwall.jpg
}

textures/saberpeak/SP_fishouterwall2
{
	qer_editorimage textures/SaberPeak_stone/SP_fishwall2.jpg
	surfaceparm stonesteps
	implicitmap textures/SaberPeak_stone/SP_fishwall2.jpg
}

textures/saberpeak/SP_metalblinds
{
	qer_editorimage textures/SaberPeak_structure/SP_metalblinds.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_metalblinds.jpg
}

textures/saberpeak/SP_kashte
{
	qer_editorimage textures/SaberPeak_other/SP_kashte.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_other/SP_kashte.jpg
}


textures/saberpeak/SP_fishdraw1
{
	qer_editorimage textures/SaberPeak_items/SP_fishboard.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	polygonoffset
	implicitmap textures/SaberPeak_items/SP_fishboard.jpg
}

textures/saberpeak/SP_fishdraw2
{
	qer_editorimage textures/SaberPeak_items/sp_fish_drawings.jpg
	surfaceparm woodsteps
	surfaceparm nomarks
	polygonoffset
	implicitmap textures/SaberPeak_items/sp_fish_drawings.jpg
}




//End shaders for fish store

//Shaders related to the hangar
//**************************************
//******* Submarine and Hangar *********
//**************************************

textures/saberpeak/SP_grid
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_items/sp_grid.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm metalsteps
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_items/sp_grid.tga
}

textures/saberpeak/SP_blueprinttank
{
	qer_editorimage textures/SaberPeak_items/SP_blueprint1.jpg
	surfaceparm noimpact
	surfaceparm nomarks
	polygonoffset
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_items/SP_blueprint1.jpg
}

textures/saberpeak/SP_blueprintship
{
	qer_editorimage textures/SaberPeak_items/SP_blueprint2.jpg
	surfaceparm noimpact
	surfaceparm nomarks
	polygonoffset
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_items/SP_blueprint2.jpg
}

textures/saberpeak/SP_panel
{
	qer_editorimage textures/SaberPeak_other/SP_panelcover.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_other/SP_panelcover.jpg
}

textures/saberpeak/SP_bunkerfloor
{
	qer_editorimage textures/SaberPeak_stone/SP_bunkerfloor.jpg
	implicitmap textures/SaberPeak_stone/SP_bunkerfloor.jpg
}

textures/saberpeak/SP_hangarwall
{
	qer_editorimage textures/SaberPeak_stone/SP_hangarwall.jpg
	implicitmap textures/SaberPeak_stone/SP_hangarwall.jpg
}

textures/saberpeak/SP_crane_shiny
{
	qer_editorimage textures/SaberPeak_structure/SP_crane_shiny.jpg
	q3map_nonplanar
	q3map_shadeangle 50
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_crane_shiny.jpg
}

textures/saberpeak/SP_crane_metal
{
	qer_editorimage textures/SaberPeak_structure/SP_crane_metal.jpg
	q3map_nonplanar
	q3map_shadeangle 135
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_crane_metal.jpg
}

textures/saberpeak/SP_crane_side
{
	qer_editorimage textures/SaberPeak_structure/SP_crane_side3.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_crane_side3.jpg
}

textures/saberpeak/SP_crane_panel
{
	qer_editorimage textures/SaberPeak_structure/sp_crane_panel.tga
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/sp_crane_panel.jpg
}

textures/saberpeak/SP_crane_side2
{
	qer_editorimage textures/SaberPeak_structure/SP_crane_side4.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_crane_side4.jpg
}

textures/saberpeak/torpedo
{
	qer_editorimage textures/swf/spipe_02.jpg
	//{
	//	map textures/swf/spipe_02.jpg
	//}
	implicitmap textures/swf/spipe_02.jpg
}

textures/saberpeak/SP_concrete
{
	qer_editorimage textures/SaberPeak_stone/SP_concrete.jpg
	implicitmap textures/SaberPeak_stone/SP_concrete.jpg
}

textures/saberpeak/SP_concrete2
{
	qer_editorimage textures/SaberPeak_stone/SP_concrete2.jpg
	implicitmap textures/SaberPeak_stone/SP_concrete2.jpg
}

textures/saberpeak/SP_hangarCeiling
{
	qer_editorimage textures/SaberPeak_stone/SP_hangarCeiling.jpg
	implicitmap textures/SaberPeak_stone/SP_hangarCeiling.jpg
}

textures/saberpeak/SP_hangarWallTrim
{
	qer_editorimage textures/SaberPeak_stone/SP_hangarWallTrim.jpg
	implicitmap textures/SaberPeak_stone/SP_hangarWallTrim.jpg
}

textures/saberpeak/SP_panel2
{
	qer_editorimage textures/SaberPeak_other/SP_panel2.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_other/SP_panel2.jpg
}

textures/saberpeak/SP_panel3
{
	qer_editorimage textures/SaberPeak_other/SP_panel3.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_other/SP_panel3.jpg
}

//////sub////////

textures/saberpeak/SP_sub_metal
{
	qer_editorimage textures/SaberPeak_structure/SP_sub_metal.jpg
	surfaceparm metalsteps
	q3map_nonplanar
	q3map_shadeangle 135
	implicitmap textures/SaberPeak_structure/SP_sub_metal.jpg
}

textures/saberpeak/SP_sub_metalcover
{
	qer_editorimage textures/SaberPeak_structure/SP_sub_metalcover.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_sub_metalcover.jpg
}

textures/saberpeak/SP_sub_gunmetal
{
	qer_editorimage textures/SaberPeak_structure/SP_sub_gunmetal.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_sub_gunmetal.jpg
}


//End shaders for hangar

//Shaders related to the cabin and it's boats
//**************************************
//******* Cabin and small boats ********
//**************************************

textures/saberpeak/sp_hammock
{
	qer_trans 0.85
	qer_editorimage textures/SaberPeak_items/sp_hammock.tga
	cull disable
	nomipmaps
	nopicmip
	surfaceparm clipmissile
	surfaceparm nomarks
	surfaceparm alphashadow
	surfaceparm pointlight
	surfaceparm trans
	implicitMask textures/SaberPeak_items/sp_hammock.tga
}

textures/saberpeak/SP_cabinwall
{
	qer_editorimage textures/SaberPeak_wood/SP_oak_plank.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_oak_plank.jpg
}

textures/saberpeak/SP_cabindoor
{
	qer_editorimage textures/SaberPeak_wood/SP_cabindoor.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_cabindoor.jpg
}

textures/saberpeak/SP_cabindoubledoor
{
	qer_editorimage textures/SaberPeak_wood/SP_cabindoubledoor.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_cabindoubledoor.jpg
}

textures/saberpeak/SP_cabinroof
{
	qer_editorimage textures/SaberPeak_wood/SP_cabinroof.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_cabinroof.jpg
}

textures/saberpeak/SP_boatWood1
{
	qer_editorimage textures/SaberPeak_wood/SP_boatWood1.jpg 
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_boatWood1.jpg
}

textures/saberpeak/SP_boatWood2
{
	qer_editorimage textures/SaberPeak_wood/SP_boatWood2.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_boatWood2.jpg 
}

textures/saberpeak/SP_seaWall
{
	qer_editorimage textures/SaberPeak_stone/sp_seawall.jpg
	implicitmap textures/SaberPeak_stone/sp_seawall.jpg
}

//**************************************
//******* SHIP *************************
//**************************************


textures/saberpeak/SP_USFlag
{
	qer_editorimage textures/SaberPeak_items/SP_usFlag.jpg
	cull none
	surfaceparm nomarks
      surfaceparm noimpact
	surfaceparm nonsolid
	implicitmap textures/SaberPeak_items/SP_usFlag.jpg 
}


textures/saberpeak/SP_shipcammo
{
	qer_editorimage textures/SaberPeak_structure/SP_shipcammo.jpg
	q3map_nonplanar 
	q3map_shadeangle 135
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_shipcammo.jpg
}

textures/saberpeak/SP_shipwindow
{
	qer_editorimage textures/SaberPeak_structure/SP_shipwindow.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_shipwindow.jpg
}

textures/saberpeak/SP_shipdoor
{
	qer_editorimage textures/SaberPeak_structure/SP_shipdoor.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_shipdoor.jpg
}

textures/saberpeak/SP_shipvent
{
	qer_editorimage textures/SaberPeak_structure/SP_shipvent.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_shipvent.jpg
}

textures/saberpeak/SP_shipGunMetal
{
	qer_editorimage textures/SaberPeak_structure/SP_ship_gunmetal.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_ship_gunmetal.jpg
}

textures/saberpeak/SP_shipGunMetal2
{
	qer_editorimage textures/SaberPeak_structure/SP_ship_gunmetal2.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_ship_gunmetal2.jpg
}

textures/saberpeak/SP_shipgun
{
	qer_editorimage textures/SaberPeak_structure/SP_shipgun.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_shipgun.jpg
}

textures/saberpeak/SP_shipmetal
{
	qer_editorimage textures/SaberPeak_structure/SP_shipmetal.jpg
	surfaceparm metalsteps
	implicitmap textures/SaberPeak_structure/SP_shipmetal.jpg
}


textures/saberpeak/SP_missileCrate
{
	qer_editorimage textures/SaberPeak_wood/SP_missileCrate.jpg
	surfaceparm woodsteps
	implicitmap textures/SaberPeak_wood/SP_missileCrate.jpg
}





//****************************************************************
//***********************WATER SHADERS****************************
//****************************************************************

////////////////////ocean//////////////////////////////
//FIXME: the ocean water textures all have alpha channels. This is causing
//all kinds of issues with the world edge merging shaders. Plus they're
//taking up too much space. Remove alpha channel, and rewrite
//shaders to use alpha mod brushes for transparency instead of the
//alpha channel. This will probably require redoing some of the water.

//blue water
textures/saberpeak/sp_deepWater
{
	qer_editorimage textures/SaberPeak_terrain/sp_deepWater.tga
	deformVertexes move 0 0 10 sin 0 2 0.3 0.09
	cull none
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/SaberPeak_terrain/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .03 0
	}
	{ 
		map textures/SaberPeak_terrain/sp_deepWater.tga
		blendFunc blend
		alphaGen vertex
		tcMod scroll .03 0
	}
}

//green water
textures/saberpeak/sp_mediumWater
{
	qer_editorimage textures/SaberPeak_terrain/sp_mediumWater.tga
	deformVertexes move 0 0 10 sin 0 2 0.3 0.09
	cull none
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/SaberPeak_terrain/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .03 0
	}
}

//clear water with foam/waves
textures/saberpeak/sp_shallowWater
{
	qer_editorimage textures/SaberPeak_terrain/sp_foamWater.tga
	deformVertexes move 0 0 10 sin 0 2 0.3 0.09
	cull none
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nonsolid
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )

	{ 
		map textures/SaberPeak_terrain/sp_foamWater.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		alphaGen oneMinusVertex
		rgbGen wave sin 0 0.7 0.5 0.09
		tcMod scale 3 1
		tcMod scroll 1 0
	}
	{ 
		map textures/SaberPeak_terrain/sp_foamWater.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		alphaGen oneMinusVertex
		tcMod scale 3 1
		rgbGen wave sin 0 0.3 0 0.09
		tcMod scroll -.6 0
	}
	{ 
		map textures/SaberPeak_terrain/sp_mediumWater.tga
		blendFunc blend
		alphaGen vertex
		tcMod scroll .03 0

	}
}

///////////////////////end ocean//////////////////


//////////////////////fountain///////////////////
textures/saberpeak/sp_fountainVertical
{
	qer_editorimage textures/SaberPeak_terrain/sp_fountain1.tga
	qer_trans .5
	cull none
	nomipmaps
	nopicmip
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/SaberPeak_terrain/sp_fountain1.tga
		blendfunc blend
		depthwrite
		alphaGen vertex
		tcmod scroll -0.25 -2
	}
	{
		map textures/SaberPeak_terrain/sp_fountain2.tga
		blendfunc gl_src_alpha gl_one
		depthwrite
		alphaGen vertex
		tcmod scroll 0.5 -1.2
	}
}

textures/saberpeak/sp_fountainHorizontal
{
	qer_editorimage textures/SaberPeak_terrain/sp_fountain1.tga
	qer_trans .5
	nomipmaps
	nopicmip
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	surfaceparm trans
	{
		map textures/SaberPeak_terrain/sp_fountain1.tga
		blendfunc blend
		depthwrite
		alphaGen vertex
		tcmod scroll -0.15 -0.2
	}

	{
		map textures/SaberPeak_terrain/sp_fountain2.tga
		blendfunc gl_src_alpha gl_one
		depthwrite
		alphaGen vertex
		tcmod scroll 0.3 0.1
	}
}
//*********************END WATER******************************


//**************************************************************
//************WORLD EDGE MERGING SHADERS************************
//FIXME FIXME FIXME FIXME: these things are a mess. Too many of them //and too stupid. Fix for final release.
// RGB value used for horizon = ( 0.753 0.878 0.973 ). DO NOT modify
//because it has to match sky_arc_masked.tga 
//**************************************************************


//water merging into horizon
textures/saberpeak/SP_skyWaterMerge
{
	qer_editorimage textures/SaberPeak_editor/sp_ed_horizon.tga
	deformVertexes move 0 0 10 sin 0 2 0.3 0.09
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	surfaceparm noimpact
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm trans
	polygonoffset
	{ 
		map textures/SaberPeak_terrain/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .03 0
	}
	{ 
      	map textures/SaberPeak_terrain/sp_deepWater.tga
		blendFunc blend
		tcMod scroll .03 0
	}
	{ 
		map $whiteimage
		rgbGen const ( 0.753 0.878 0.973 )
		blendFunc blend
		alphaGen vertex
	} 	
}

//used for the horizon merging part of the water when looking inside out. Same as deep water but has culling since SP_skyWaterMerge is transparent. VERY dumb. FIX
textures/saberpeak/sp_underWaterMerge
{
	qer_editorimage textures/SaberPeak_terrain/sp_deepWater.tga
	deformVertexes move 0 0 10 sin 0 2 0.3 0.09
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
		map textures/SaberPeak_terrain/sp_mediumWater.tga
		blendFunc blend
		tcMod scroll .03 0
	}
	{ 
		map textures/SaberPeak_terrain/sp_deepWater.tga
		blendFunc blend
		tcMod scroll .03 0
	}

}


//Don't even know what the hell this is. Used to fix some issues with
//SP_skyWaterMerge not merging right.
textures/saberpeak/sp_underWaterMerge1
{
	qer_editorimage textures/SaberPeak_terrain/sp_deepWater.tga
	deformVertexes move 0 0 10 sin 0 2 0.3 0.09
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm pointlight
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	{ 
      	map textures/SaberPeak_terrain/sp_deepWater.tga
	}
	{ 
		map $whiteimage
		rgbGen const ( 0.753 0.878 0.973 )
		blendFunc blend
		alphaGen vertex
	}
}

//sand going into water. RGB value used for sp_sand0.jpg has to match
//value used in sp_terrain.shader. Don't forget to apply any changes 
//made to both versions.
textures/saberpeak/SP_sandWaterMerge
{
	qer_editorimage textures/SaberPeak_terrain/sp_sand0.jpg
	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )
	q3map_lightmapmergable
	{
		map textures/SaberPeak_terrain/sp_deepWater.tga
	}
	{ 
		map textures/SaberPeak_terrain/sp_sand0.jpg
		rgbGen const ( 0.85 0.85 0.85 )
		blendFunc blend
		alphaGen vertex
	}
	{ 
		map $lightmap 
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	} 
}

//*********************************************************************

//*****************************SKY*************************************
textures/saberpeak/sp_sky
{
	qer_editorimage textures/SaberPeak_terrain/sp_sky.tga
	q3map_sunExt 0.99216 0.95686 0.82353 450 315 50 2 16
	q3map_skyLight 75 3
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	
	skyparms textures/SaberPeak_terrain/env/sky 2048 -
	
	nopicmip
	nomipmaps
	
	{
		map textures/SaberPeak_terrain/sp_sky.tga
		tcMod scroll 0.002 -0.002
		rgbGen identityLighting
	}
	{
		map textures/SaberPeak_terrain/sp_sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}